package com.devplatform.admin;

import lombok.extern.slf4j.Slf4j;
import org.apache.catalina.filters.CorsFilter;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import springfox.documentation.swagger2.annotations.EnableSwagger2;


/**
 * springboot启动类
 *
 * @author Administrator
 */
@SpringBootApplication
@EnableSwagger2
@Slf4j
@MapperScan(basePackages = "com.devplatform.**.dao")
@EnableEurekaClient
@EnableFeignClients
@EnableScheduling
@EnableTransactionManagement
@ComponentScan(basePackages = {"com.devplatform"})
public class AdminApplication {

  public static void main(String[] args) {
    SpringApplication.run(AdminApplication.class, args);
  }

  @Bean
  public ServerEndpointExporter serverEndpointExporter() {
    return new ServerEndpointExporter();
  }

  @Bean
  public RestTemplate restTemplate() {
    // 复杂构造函数的使用
    SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
    // 设置超时
    requestFactory.setConnectTimeout(3000);
    requestFactory.setReadTimeout(3000);
    return new RestTemplate(requestFactory);
  }
}
