package com.devplatform.admin.common.scheduling;

import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.stereotype.Component;

import java.util.Date;

/** 设备拓扑监测定时任务，生成报警信息（站点） @Author: jzj @Date: 2020/9/18 15:02 */
@Component
public class TopologyTasks implements SchedulingConfigurer {

  private Long timer;

  public Long getTimer() {
    return timer;
  }

  public void setTimer(Long timer) {
    this.timer = timer;
  }

  private String cron;

  public String getCron() {
    return cron;
  }

  public void setCron(String cron) {
    this.cron = cron;
  }

  @Override
  public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
    taskRegistrar.addTriggerTask(
        new Runnable() {
          @Override
          public void run() {
//            try {
//              if (sysSystem == null) {
//                sysSystem = sysSystemService.getOne(null);
//
//                // 站点
//                if (Constants.STRING_1.equals(sysSystem.getType())) {
//                  SysParams bean = new SysParams();
//                  bean =
//                      sysParamsService.getOne(
//                          new QueryWrapper<SysParams>()
//                              .eq("name", "topology")
//                              .eq("station_id", sysSystem.getCode()));
//                  if(StringUtils.isNotBlank(bean.getValue())){
//                    timer = Long.parseLong(bean.getValue())*1000;
//                  }
//                }
//                // 线路或者路网
//                if (Constants.STRING_2.equals(sysSystem.getType()) || Constants.STRING_3.equals(sysSystem.getType())) {
//                  RtSysParams bean = new RtSysParams();
//                  bean =
//                      rtSysParamsService.getOne(
//                          new QueryWrapper<RtSysParams>()
//                              .eq("name", "topology")
//                              .eq("station_id", sysSystem.getCode()));
//                  if(StringUtils.isNotBlank(bean.getValue())){
//                    timer = Long.parseLong(bean.getValue())*1000;
//                  }
//                }
//              }
//              // 站点,设备报警信息生成
//              if (Constants.STRING_1.equals(sysSystem.getType())) {
//                eqEquipmentService.topology(250, sysSystem.getCode());
//              }
//              // 路网或线路,设备报警信息生成
//              if (Constants.STRING_2.equals(sysSystem.getType()) || Constants.STRING_3.equals(sysSystem.getType())) {
//                rtEqEquipmentService.topology(250, sysSystem.getCode(), sysSystem.getType());
//              }
//            } catch (Exception e) {
//              e.printStackTrace();
//            }
          }
        },
        new Trigger() {

          @Override
          public Date nextExecutionTime(TriggerContext triggerContext) {
            // System.out.println("站点-----------"+cron);
            if (timer == null) {
              timer = (long)15000;
            }
            PeriodicTrigger periodicTrigger = new PeriodicTrigger(timer);
            Date nextExecDate = periodicTrigger.nextExecutionTime(triggerContext);
            return nextExecDate;
          }
        });
  }
}
