package com.devplatform.admin.common.utils;


import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

/**
 * @author Muceball-laptop
 * @date 2020/11/20 9:59
 */
public class Aes {

    private static final String KEY_ALGORITHM = "AES";
    /**
     * 默认的加密算法
     */
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    /**
     * 密码（Suntray的MD5加密大写）
     */
    private static final String KEY = "7CD6497763B8449F";

    /**
     * AES 加密操作
     *
     * @param content 待加密内容
     * @return 返回Base64转码后的加密数据
     */
    public static String encrypt(String content) {
        try {
            // 创建密码器
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = content.getBytes("utf-8");
            // 初始化为加密模式的密码器
            cipher.init(Cipher.ENCRYPT_MODE, getSecretKey(KEY));
            // 加密
            byte[] result = cipher.doFinal(byteContent);
            //通过Base64转码返回
            return org.apache.commons.codec.binary.Base64.encodeBase64String(result);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * AES 解密操作
     *
     * @param content
     * @return
     */
    public static String decrypt(String content) {
        try {
            //实例化
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            //使用密钥初始化，设置为解密模式
            cipher.init(Cipher.DECRYPT_MODE, getSecretKey(KEY));
            //执行操作
            byte[] result = cipher.doFinal(org.apache.commons.codec.binary.Base64.decodeBase64(content));
            return new String(result, "utf-8");
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * 生成加密秘钥
     *
     * @return
     * @throws UnsupportedEncodingException
     */
    private static SecretKeySpec getSecretKey(final String key) throws UnsupportedEncodingException {
        try {
            // 转换为AES专用密钥
            return new SecretKeySpec(Arrays.copyOf(key.getBytes("utf-8"), 16), KEY_ALGORITHM);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String plainText = "admin";

        System.out.println("plainText:" + plainText);

        String encryptionText = Aes.encrypt(plainText);
        System.out.println("加密后的密码(encryptionText):" + encryptionText);

        System.out.println("解密(decrypt):" + Aes.decrypt(encryptionText));

    }
}
