package com.devplatform.admin.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
/**
 * @author Administrator
 */
public class SocketClient {
  public static void main(String[] args) throws Exception {

    String str =
        "00000059017d00000053e998b2e58cba3120e58f91e7949fe68aa5e8ada62ce6a8a1e5bc8fe588a4e588abe4b8ba5be99d9ee6b395e585a5e4beb55d233563666165623437613532653431303439386633303730613363303135643664";
    byte[] b = hexString2Bytes(str.substring(20).toString());
    String alarmMsg2 = new String(b, "UTF-8");
    System.out.println("=========数据类型：" + alarmMsg2);
    String ip = "10.20.72.29";
    int port = 30003;

    // 模拟
    //        String ip = "10.20.251.77";
    //        int port = 3003;
    Socket socket = null;
    BufferedInputStream bis = null;
    DataInputStream dis = null;
    try {
      socket = new Socket(ip, port);
      // 封装输入流（接收服务端的流）
      bis = new BufferedInputStream(socket.getInputStream());
      dis = new DataInputStream(bis);
      // 02 08 65 17 C0 B1 23 58 50 B8
      // 一次读取一个byte
      byte[] bytes = new byte[1];
      StringBuilder ret = new StringBuilder();

      while (dis.read(bytes) != -1) {
        ret.append(bytesToHexString(bytes));
        // 一个请求完毕
        if (dis.available() == 0) {
          try {
            System.out.println("=========数据类型：" + ret.substring(8, 10));
            // 类型
            if ("01".equals(ret.substring(8, 10))) {
              // 捕获告警信息

              if ("00".equals(ret.substring(12, 14))) {
                System.out.println("=========类型：" + ret.substring(8, 10));
                System.out.println("=========编号：" + ret.substring(10, 12));
                System.out.println("=========防区状态类型说明：" + ret.substring(12, 14));

                String alarmMsg =
                    new String(hexString2Bytes(ret.toString().substring(20)), "UTF-8");
                System.out.println("=========解析前：" + ret);
                System.out.println("=========解析后：" + alarmMsg);
              } else {
                System.out.println("=========原始值：" + ret);
              }
              String alarmMsg = ret.substring(12, 14) + "";
              // 给前端发送告警信息及提供前端摄像头的信息及操作摄像头。
              JSONObject jsonObject = new JSONObject();
              jsonObject.put("type", "报警信息");
              jsonObject.put("code", ret.substring(10, 12) + "");
              jsonObject.put("description", alarmMsg);
            }
            // 写入数据库

          } catch (Exception e) {
          }
          ret.delete(0, ret.length());
        }
      }
    } catch (Exception e) {
    } finally {
      if (socket != null) {
        try {
          socket.close();
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
      if (dis != null) {
        try {
          dis.close();
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
      if (bis != null) {
        try {
          bis.close();
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
    }
  }

  /**
   * byte[]数组转换为16进制的字符串
   *
   * @param bytes 要转换的字节数组
   * @return 转换后的结果
   */
  public static String bytesToHexString(byte[] bytes) {
    StringBuilder sb = new StringBuilder();
    for (int i = 0; i < bytes.length; i++) {
      String hex = Integer.toHexString(0xFF & bytes[i]);
      if (hex.length() == 1) {
        sb.append('0');
      }
      sb.append(hex);
    }
    return sb.toString();
  }

  /**
   * 字符转换为字节
   * @param c
   * @return
   */
  private static byte charToByte(char c) {
    return (byte) "0123456789ABCDEF".indexOf(c);
  }

  /**
   * 16进制字符串转字节数组
   * @param hex
   * @return
   */
  public static byte[] hexString2Bytes(String hex) {

    if ((hex == null) || ("".equals(hex))) {
      return null;
    } else if (hex.length() % Constants.INT_2 != 0) {
      return null;
    } else {
      hex = hex.toUpperCase();
      int len = hex.length() / 2;
      byte[] b = new byte[len];
      char[] hc = hex.toCharArray();
      for (int i = 0; i < len; i++) {
        int p = 2 * i;
        b[i] = (byte) (charToByte(hc[p]) << 4 | charToByte(hc[p + 1]));
      }
      return b;
    }
  }
}
