package com.devplatform.admin.config;

import com.devplatform.admin.modules.sys.bean.SysSystem;
import com.devplatform.admin.modules.sys.service.SysSystemService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;

// @Component
// @Order(2)

/**
 * @author Administrator
 */
public class InitRunner implements CommandLineRunner {

  @Autowired private SysSystemService sysSystemService;

  @Override
  public void run(String... args) {

    // 获取当前系统信息
    SysSystem one = sysSystemService.getOne(null);
    if (one == null || StringUtils.isBlank(one.getType())) {
      throw new RuntimeException("未能读取到系统配置！");
    }
    GlobalParameter.setId(one.getId());
    GlobalParameter.setCode(one.getCode());
    GlobalParameter.setName(one.getName());
    GlobalParameter.setType(one.getType());
    GlobalParameter.setSysSign(one.getSysSign());
    System.err.println("系统标识----->" + one.toString());
  }
}
