package com.devplatform.admin.modules.eq.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.admin.common.scheduling.SimpleJob;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.TestClient;
import com.devplatform.admin.config.WebSocket;
import com.devplatform.admin.modules.eq.bean.TimedTask;
import com.devplatform.admin.modules.eq.service.EquipmentService;
import com.devplatform.admin.modules.eq.service.TimedTaskService;
import com.devplatform.admin.modules.liresource.bean.LiResource;
import com.devplatform.admin.modules.liresource.bean.LiStation;
import com.devplatform.admin.modules.liresource.model.LiResourceModel;
import com.devplatform.admin.modules.liresource.service.LiResourceService;
import com.devplatform.admin.modules.liresource.service.LiStationService;
import com.devplatform.admin.modules.sys.bean.SysSystemParams;
import com.devplatform.admin.modules.sys.bean.SysSystemRunningTime;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.service.SysSystemParamsService;
import com.devplatform.admin.modules.sys.service.SysSystemRunningTimeService;
import com.devplatform.common.util.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.quartz.*;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 设备控制
 * @author dxw
 */
@Api(tags={"设备接口"})
@RestController
@RequestMapping("/equipment")
public class EquipmentController extends AbstractController {
	private static SchedulerFactory gSchedulerFactory = new StdSchedulerFactory();
	private static String JOB_GROUP_NAME = "quartz_name";
	private static String TRIGGER_GROUP_NAME = "quartz_group";
	@Autowired
	private EquipmentService equipmentService;
	@Autowired
	private SysSystemParamsService sysSystemParamsService;
	@Autowired
	private SysSystemRunningTimeService sysSystemRunningTimeService;
	@Autowired
	private TimedTaskService timedTaskService;
	@Autowired
	private LiStationService liStationService;
	@Autowired
	private WebSocket webSocket;
	@Autowired
	private LiResourceService liResourceService;

	/**
	 * 获取每个设备最新的参数值
	 * @return
	 */
	@ApiOperation(value="获取每个设备最新的参数值", notes="获取每个设备最新的参数值")
	@GetMapping("/getListParam")
	public R getListParam() {
		Map<String,Object> list = equipmentService.getList();
		return R.ok().put("bean", list);
	}

	/**
	 * 发送每个设备最新的参数值
	 * @return
	 */
	@ApiOperation(value="发送每个设备最新的参数值", notes="发送每个设备最新的参数值")
	@PostMapping("/sendParamsInfo")
	public R sendParamsInfo() {
		Map<String,Object> list = equipmentService.getList();
		webSocket.sendAllMessage(JSONObject.toJSONString(list));
		return R.ok();
	}

	/**
	 * 切换人工/节能模式
	 * @return
	 */
	@ApiOperation(value="切换人工/节能模式", notes="切换人工/节能模式")
	@GetMapping("/changeType")
	public R changeType(Integer type) {
		Date time = new Date();
		SysSystemParams sysSystemParams = new SysSystemParams();
		sysSystemParams.setId(Constants.STRING_1);
		sysSystemParams.setType(type);
		sysSystemParams.setUpdateTime(time);
		sysSystemParams.setSun(Constants.INT_2);
		sysSystemParams.setFan(Constants.INT_2);
		sysSystemParams.setNan(Constants.INT_2);
		sysSystemParamsService.update(sysSystemParams,new LambdaQueryWrapper<SysSystemParams>()
				.eq(SysSystemParams::getId,Constants.STRING_1));

		SysSystemRunningTime sysSystemRunningTime = sysSystemRunningTimeService.getOne(new LambdaQueryWrapper<SysSystemRunningTime>()
				.orderByDesc(SysSystemRunningTime::getUpdateTime).last("limit 1"));
		sysSystemRunningTime.setEndTime(time);
		sysSystemRunningTime.setUpdateTime(time);
		sysSystemRunningTimeService.update(sysSystemRunningTime,new LambdaQueryWrapper<SysSystemRunningTime>()
				.eq(SysSystemRunningTime::getId,sysSystemRunningTime.getId()));

		SysSystemRunningTime temp = new SysSystemRunningTime();
		temp.setStartTime(time);
		temp.setType(type);
		temp.setEndTime(time);
		temp.setUpdateTime(time);
		sysSystemRunningTimeService.save(temp);

		//如果切换成节能模式，则关闭定时任务
		if(type == Constants.INT_2){
			TimedTask timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getStatus,Constants.INT_1).last("limit 1"));
			if(timedTask != null){
				this.timedTask(timedTask.getId(),timedTask.getStartTime(),timedTask.getEndTime(),Constants.INT_2,1,null,"");
			}
		}

		Map<String,Object> list = equipmentService.getList();
		webSocket.sendAllMessage(JSONObject.toJSONString(list));
		return R.ok();
	}

	/**
	 * @param jobName @Description 移除任务(使用默认的任务组名 ， 触发器名 ， 触发器组名)
	 */
	public static void removeJob(String jobName) {
		TriggerKey triggerKey1 = TriggerKey.triggerKey(jobName+"-start", TRIGGER_GROUP_NAME);
		TriggerKey triggerKey2 = TriggerKey.triggerKey(jobName+"-end", TRIGGER_GROUP_NAME);
		JobKey jobKey1 = JobKey.jobKey(jobName+"-start", JOB_GROUP_NAME);
		JobKey jobKey2 = JobKey.jobKey(jobName+"-end", JOB_GROUP_NAME);
		try {
			Scheduler sched = gSchedulerFactory.getScheduler();
			Trigger trigger1 = (Trigger) sched.getTrigger(triggerKey1);
			Trigger trigger2 = (Trigger) sched.getTrigger(triggerKey2);
			if (trigger1 == null && trigger2 == null) {
				return;
			}
			if(trigger1 != null){
				// 停止触发器
				sched.pauseTrigger(triggerKey1);
				// 移除触发器
				sched.unscheduleJob(triggerKey1);
				// 删除任务
				sched.deleteJob(jobKey1);
				System.err.println("移除任务:" + jobName+"-start");
			}
			if(trigger2 != null){
				// 停止触发器
				sched.pauseTrigger(triggerKey2);
				// 移除触发器
				sched.unscheduleJob(triggerKey2);
				// 删除任务
				sched.deleteJob(jobKey2);
				System.err.println("移除任务:" + jobName+"-end");
			}
		} catch (Exception ignored) {
			System.err.println("移除定时任务出错");
		}
	}

	@ApiOperation(value = "定时任务开启/关闭", notes = "定时任务开启")
	@ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
	@PostMapping("/timedTask")
	public R timedTask(String taskId, String startTime, String endTime, Integer status,Integer businessType,Integer type, String isReboot) {
		TimedTask timedTask = null;
		//如果重启是启动的定时任务，不用更新数据库
		if(StringUtils.isBlank(isReboot)){
			SysUserEntity user = getUser();
			if(StringUtils.isBlank(taskId)){
				timedTask = new TimedTask();
				timedTask.setStartTime(startTime);
				timedTask.setBusinessType(businessType);
				timedTask.setType(type);
				timedTask.setEndTime(endTime);
				timedTask.setCreateTime(new Date());
				timedTask.setCreateUserId(user.getUserId());
				timedTask.setStatus(status);
				timedTaskService.save(timedTask);
			}else {
				timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getBusinessType,businessType)
						.eq(type != null,TimedTask::getType,type).last("limit 1"));
				timedTask.setStartTime(startTime);
				timedTask.setBusinessType(businessType);
				timedTask.setType(type);
				timedTask.setEndTime(endTime);
				timedTask.setStatus(status);
				timedTask.setUpdateTime(new Date());
				timedTask.setUpdateUserId(user.getUserId());
				timedTaskService.update(timedTask, new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getId,taskId));
			}

			taskId = timedTask.getId();
		}

		//开启
		if (status == 1) {
			//设置定时任务
			R error = setTimeTask(taskId,businessType,type,startTime, endTime);
			if (error != null) {
				return error;
			}
		}else{
			//关闭定时任务
			removeJob(taskId);
		}
		return R.ok();
	}

	/**
	 * 设置定时任务
	 * @param id
	 * @param startTime
	 * @param endTime
	 * @return
	 */
	private R setTimeTask(String id,Integer businessType,Integer type ,String startTime, String endTime){
		try {
			Scheduler sched = gSchedulerFactory.getScheduler();
			JobDetail job1 = null;
			Trigger trigger1 = null;
			JobDetail job2 = null;
			Trigger trigger2 = null;
			if(StringUtils.isNotBlank(startTime)){
				JobDataMap resJobDataMap1 = new JobDataMap();
				//设备开启
				resJobDataMap1.put("status", Constants.INT_1);
				resJobDataMap1.put("businessType", businessType);
				resJobDataMap1.put("type", type);

				job1 = JobBuilder.newJob(SimpleJob.class).withIdentity(id+"-start", JOB_GROUP_NAME).usingJobData(resJobDataMap1).build();
				String cron1 = createCron(startTime);
				trigger1 = TriggerBuilder.newTrigger().withIdentity(id+"-start", TRIGGER_GROUP_NAME).startAt(new Date())
						.withSchedule(CronScheduleBuilder.cronSchedule(cron1).withMisfireHandlingInstructionDoNothing()).build();
			}
			if(StringUtils.isNotBlank(endTime)){
				JobDataMap resJobDataMap2 = new JobDataMap();
				//设备关闭
				resJobDataMap2.put("status", Constants.INT_2);
				resJobDataMap2.put("businessType", businessType);
				resJobDataMap2.put("type", type);

				job2 = JobBuilder.newJob(SimpleJob.class).withIdentity(id+"-end", JOB_GROUP_NAME).usingJobData(resJobDataMap2).build();
				String cron2 = createCron(endTime);
				trigger2 = TriggerBuilder.newTrigger().withIdentity(id+"-end", TRIGGER_GROUP_NAME).startAt(new Date())
						.withSchedule(CronScheduleBuilder.cronSchedule(cron2).withMisfireHandlingInstructionDoNothing()).build();
			}


			if(job1 != null && trigger1 != null){
				// 交给scheduler去调度
				sched.scheduleJob(job1, trigger1);
			}

			if(job2 != null && trigger2 != null){
				sched.scheduleJob(job2, trigger2);
			}
			// 启动
			if (!sched.isShutdown()) {
				sched.start();
			}
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			System.err.println("设置定时任务1：" + id + "\n\t下次运行时间：" + sdf.format(trigger1.getNextFireTime()));
//			System.err.println("设置定时任务2：" + id + "\n\t下次运行时间：" + sdf.format(trigger2.getNextFireTime()));
		} catch (SchedulerException e) {
			e.printStackTrace();
			return R.error("时间设置有误！");
		}
		return null;
	}

	/**
	 * 生成cron表达
	 * @param time 时间
	 * @return cron
	 */
	public String createCron(String time){
		String[] strs = time.split(":");
		StringBuilder sb = new StringBuilder()
				.append(0).append(" ")
				.append(strs[1]).append(" ")
				.append(strs[0]).append(" * * ? ");
		return sb.toString();
	}

	/**
	 * 获取电动门帘的定时任务数据
	 * @return
	 */
	@ApiOperation(value="获取电动门帘的定时任务数据", notes="获取电动门帘的定时任务数据")
	@GetMapping("/getAllDdml")
	public R getAllDdml() {
		List<TimedTask> timedTasks = timedTaskService.list(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getBusinessType,Constants.INT_2));
		return R.ok().put("list",timedTasks);
	}

	/**
	 * 候车大厅头上所有显示数据
	 * @return
	 */
	@ApiOperation(value="候车大厅头上所有显示数据", notes="候车大厅头上所有显示数据")
	@GetMapping("/getAllHcdt")
	public R getAllHcdt() {
		SysSystemParams sysSystemParams = sysSystemParamsService.getById(Constants.STRING_1);
		return R.ok().put("sysSystemParams", sysSystemParams);
	}

	@ApiOperation(value = "切换模式", notes = "切换模式")
	@ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
	@PostMapping("/checkModel")
	public R checkModel(Integer type,Integer status) {
		// 控制资源点启停
		checkModelOnOrOff(type, status);

		SysSystemParams sysSystemParams = sysSystemParamsService.getById(Constants.STRING_1);
		if(type == Constants.INT_1){
			sysSystemParams.setSun(status);
			sysSystemParams.setFan(Constants.INT_2);
			sysSystemParams.setNan(Constants.INT_2);
		}else if(type == Constants.INT_2){
			sysSystemParams.setSun(Constants.INT_2);
			sysSystemParams.setFan(status);
			sysSystemParams.setNan(Constants.INT_2);
		}else if(type == Constants.INT_3){
			sysSystemParams.setSun(Constants.INT_2);
			sysSystemParams.setFan(Constants.INT_2);
			sysSystemParams.setNan(status);
		}
		sysSystemParamsService.update(sysSystemParams,new LambdaQueryWrapper<SysSystemParams>()
				.eq(SysSystemParams::getId,sysSystemParams.getId()));

		Map<String,Object> list = equipmentService.getList();
		webSocket.sendAllMessage(JSONObject.toJSONString(list));

		return R.ok();
	}



	/**
	 * 查询定时温控里面的数据
	 * @return
	 */
	@ApiOperation(value="查询定时温控里面的数据", notes="查询定时温控里面的数据")
	@GetMapping("/getAllDswk")
	public R getAllDswk() {
		TimedTask timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getBusinessType,Constants.INT_1).last("limit 1"));
		return R.ok().put("timedTask", timedTask);
	}

	@ApiOperation(value = "温度设定", notes = "温度设定")
	@PostMapping("/changeTemperature")
	public R changeTemperature(String temperature) {
		TimedTask timedTask = timedTaskService.getOne(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getBusinessType,Constants.INT_1).last("limit 1"));
		timedTask.setTemperature(temperature);
		timedTaskService.update(timedTask,new LambdaQueryWrapper<TimedTask>()
				.eq(TimedTask::getId,timedTask.getId()));
		return R.ok();
	}

	/**
	 * @Title: 设备开关
	 * @param model
	 * @return Map<String,String>
	 */
	@PostMapping("/onOrOff")
	public Map<String, Object> doorOnOff(@RequestBody LiResourceModel model) {
//		String postUrl = getUrl(model.getStationId());
		return onOrOff(model);
	}

	/**
	 * 根据选择人工模式，来控制资源点启停
	 * @param type	1=供暖模式，2=机械通风，3=自然通风
	 * @param status 1=开启，2=关闭
	 */
	private void checkModelOnOrOff(Integer type, Integer status) {
		List<LiResource> list = new ArrayList<LiResource>();
		// 查询所有模式匹配的资源点
		list = liResourceService.queryListByParam(type.toString());
		for (int i = 0; i < list.size(); i++) {
			LiResourceModel model = new LiResourceModel();
			model.setId(list.get(i).getId());
			model.setStatus(status==1?1:0);
			model.setActionName(list.get(i).getName() + (status==1?"开启":"关闭"));
			//操作类型，1=开关
			model.setActionType(1);
			onOrOff(model);
		}
	}

	private Map<String, Object> onOrOff(LiResourceModel model) {
		String postUrl = "http://10.2.72.33:8089/command/operation";
		Map<String, String> postParam = new HashMap<String, String>(10);
		postParam.put("liResourceId", model.getId());
		postParam.put("params", model.getStatus().toString());
		postParam.put("paramsName", model.getActionName());
		postParam.put("actionType", model.getActionType().toString());
		postParam.put("userId", getUserId());
		postParam.put("userName", getUser().getName());

		Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
		Map<String, Object> map = null;
		if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
			map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
		}
		return map;

	}

	private String getUrl(String stationId) {
		LiStation liStation = liStationService.getById(stationId);
		return liStation.getByx1();
	}


}
