package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.DlsnjInfoModel;
import com.devplatform.admin.modules.eq.bean.DlsnjInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * DlsnjInfo Mapper
 * 用于多联室内机信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface DlsnjInfoDao extends MyBaseMapper<DlsnjInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(DlsnjInfoModel model);

    /**
     * 查询多联室内机信息分页数据
     * @param model
     * @return
     */
    List<DlsnjInfo> queryPageList(DlsnjInfoModel model);

    List<Map<String, Object>> getList();
}
