package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.DlswjInfoModel;
import com.devplatform.admin.modules.eq.bean.DlswjInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * DlswjInfo Mapper
 * 用于多联室外机记录信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface DlswjInfoDao extends MyBaseMapper<DlswjInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(DlswjInfoModel model);

    /**
     * 查询多联室外机记录信息分页数据
     * @param model
     * @return
     */
    List<DlswjInfo> queryPageList(DlswjInfoModel model);

    List<Map<String, Object>> getList();
}
