package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.DlswjInfoMonthModel;
import com.devplatform.admin.modules.eq.bean.DlswjInfoMonth;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * DlswjInfoMonth Mapper
 * 用于多联室外机信息-月的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface DlswjInfoMonthDao extends MyBaseMapper<DlswjInfoMonth> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(DlswjInfoMonthModel model);

    /**
     * 查询多联室外机信息-月分页数据
     * @param model
     * @return
     */
    List<DlswjInfoMonth> queryPageList(DlswjInfoMonthModel model);

    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);
}
