package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.JfktpInfoModel;
import com.devplatform.admin.modules.eq.bean.JfktpInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * JfktpInfo Mapper
 * 用于机房空调(220V)信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface JfktpInfoDao extends MyBaseMapper<JfktpInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(JfktpInfoModel model);

    /**
     * 查询机房空调(220V)信息分页数据
     * @param model
     * @return
     */
    List<JfktpInfo> queryPageList(JfktpInfoModel model);

    List<Map<String, Object>> getList();
}
