package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.JfktpInfoHourModel;
import com.devplatform.admin.modules.eq.bean.JfktpInfoHour;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * JfktpInfoHour Mapper
 * 用于机房空调(220V)信息-时的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface JfktpInfoHourDao extends MyBaseMapper<JfktpInfoHour> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(JfktpInfoHourModel model);

    /**
     * 查询机房空调(220V)信息-时分页数据
     * @param model
     * @return
     */
    List<JfktpInfoHour> queryPageList(JfktpInfoHourModel model);

    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);
}
