package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.PfjInfoMonthModel;
import com.devplatform.admin.modules.eq.bean.PfjInfoMonth;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * PfjInfoMonth Mapper
 * 用于排风机信息-月的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface PfjInfoMonthDao extends MyBaseMapper<PfjInfoMonth> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(PfjInfoMonthModel model);

    /**
     * 查询排风机信息-月分页数据
     * @param model
     * @return
     */
    List<PfjInfoMonth> queryPageList(PfjInfoMonthModel model);

    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);
}
