package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.SbInfoModel;
import com.devplatform.admin.modules.eq.bean.SbInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * SbInfo Mapper
 * 用于水泵信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SbInfoDao extends MyBaseMapper<SbInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SbInfoModel model);

    /**
     * 查询水泵信息分页数据
     * @param model
     * @return
     */
    List<SbInfo> queryPageList(SbInfoModel model);

    List<Map<String, Object>> getList();
}
