package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.SljfgInfoModel;
import com.devplatform.admin.modules.eq.bean.SljfgInfo;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;
import java.util.Map;

/**
 * SljfgInfo Mapper
 * 用于室内机风柜信息的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SljfgInfoDao extends MyBaseMapper<SljfgInfo> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SljfgInfoModel model);

    /**
     * 查询室内机风柜信息分页数据
     * @param model
     * @return
     */
    List<SljfgInfo> queryPageList(SljfgInfoModel model);

    List<Map<String, Object>> getList();
}
