package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.SljfgInfoMonthModel;
import com.devplatform.admin.modules.eq.bean.SljfgInfoMonth;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * SljfgInfoMonth Mapper
 * 用于室内机风柜信息-月的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SljfgInfoMonthDao extends MyBaseMapper<SljfgInfoMonth> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SljfgInfoMonthModel model);

    /**
     * 查询室内机风柜信息-月分页数据
     * @param model
     * @return
     */
    List<SljfgInfoMonth> queryPageList(SljfgInfoMonthModel model);

    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String, Object>> queryListByParam(@Param("startTime")String startTime,@Param("endTime")String endTime);
}
