package com.devplatform.admin.modules.eq.dao;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.SnqxzInfoHourModel;
import com.devplatform.admin.modules.eq.bean.SnqxzInfoHour;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * SnqxzInfoHour Mapper
 * 用于室内气象站信息-时的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SnqxzInfoHourDao extends MyBaseMapper<SnqxzInfoHour> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SnqxzInfoHourModel model);

    /**
     * 查询室内气象站信息-时分页数据
     * @param model
     * @return
     */
    List<SnqxzInfoHour> queryPageList(SnqxzInfoHourModel model);

    /**
     * 查询室内气象站信息-天分页数据
     * @param page
     * @param params
     * @return
     */
    Page<Map<String, Object>> queryPageListByParam(@Param("page") Page<Map<String, Object>> page,
                                                   @Param("params") Map<String, Object> params);

    List<Map<String,Object>> getList(@Param("resourceId")String resourceId, @Param("startTime")String startTime,@Param("endTime")String endTime);

    List<Map<String, Object>> getListFx(@Param("region")Integer region,@Param("startTime")String startTime,@Param("endTime")String endTime);

    List<Map<String, Object>> getParamGroupByRegion(@Param("region")Integer region);
}
