package com.devplatform.admin.modules.eq.dao;
import com.devplatform.admin.modules.eq.bean.TotalHour;
import com.devplatform.admin.modules.eq.model.TotalHourModel;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * TotalHour Mapper
 * 用于当天能耗-时的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface TotalHourDao extends MyBaseMapper<TotalHour> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(TotalHourModel model);

    /**
     * 查询当天能耗-时分页数据
     * @param model
     * @return
     */
    List<TotalHour> queryPageList(TotalHourModel model);

    List<Map<String,Object>> queryList(@Param("startTime")String startTime,@Param("endTime")String endTime);
}
