package com.devplatform.admin.modules.eq.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.eq.model.TotalMonthModel;
import com.devplatform.admin.modules.eq.bean.TotalMonth;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * TotalMonth Mapper
 * 用于能耗-月的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface TotalMonthDao extends MyBaseMapper<TotalMonth> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(TotalMonthModel model);

    /**
     * 查询能耗-月分页数据
     * @param model
     * @return
     */
    List<TotalMonth> queryPageList(TotalMonthModel model);

    List<Map<String, Object>> queryList(@Param("startTime")String startTime,@Param("endTime")String endTime);
}
