package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.common.utils.DateUtils;
import com.devplatform.admin.modules.eq.service.*;
import com.devplatform.admin.modules.sys.bean.SysSystemParams;
import com.devplatform.admin.modules.sys.service.SysSystemParamsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 设备的service接口实现类
 * @author dxw
 */
@Service("analysisService")
public class AnalysisServiceImpl implements AnalysisService {
    @Autowired
    private SysSystemParamsService sysSystemParamsService;
    @Autowired
    private TotalDayService totalDayService;
    @Autowired
    private TotalHourService totalHourService;
    @Autowired
    private TotalMonthService totalMonthService;

    @Autowired
    private FlrbInfoService flrbInfoService;
    @Autowired
    private JfktpInfoService jfktpInfoService;
    @Autowired
    private PfjInfoService pfjInfoService;
    @Autowired
    private DlswjInfoService dlswjInfoService;
    @Autowired
    private SljfgInfoService sljfgInfoService;

    @Override
    public Map<String,Object> getSyParam(){
        Map<String,Object> map = new HashMap<>();
        try {
            SysSystemParams sysSystemParams = sysSystemParamsService.getById(Constants.STRING_1);

            Integer dayTime = Integer.valueOf(sysSystemParams.getSystemRunningTime())/(24*60*60);
            Integer hourTime = Integer.valueOf(sysSystemParams.getSystemRunningTime())%(24*60*60)/(60*60);
            List<Integer> timeList = new ArrayList<>();
            timeList.add(dayTime);
            timeList.add(hourTime);

            //人工/节能模式
            map.put("type",sysSystemParams.getType());
            //系统运行时间
            map.put("systemRunningTime",timeList);
            //报警总数
            map.put("faultAlarm",2);
            //供暖模式
            map.put("sun",sysSystemParams.getSun());
            //机械通风模式
            map.put("fan",sysSystemParams.getFan());
            //自然通风模式
            map.put("nan",sysSystemParams.getNan());

            Integer t = 0;
            if(sysSystemParams.getSun() == Constants.INT_1){
                t = 1;
            }else if(sysSystemParams.getFan() == Constants.INT_1){
                t = 2;
            }else if(sysSystemParams.getNan() == Constants.INT_1){
                t = 3;
            }
            //当前模式
            map.put("currentModel",t);

            //能耗
            Map<String,Object> energy = new HashMap<>();
            //当天
            //手动运行时间-天
            energy.put("sdSystemRunningTimeDay",sysSystemParams.getSdSystemRunningTimeDay());
            //节能运行时间-天
            energy.put("jnSystemRunningTimeDay",sysSystemParams.getJnSystemRunningTimeDay());
            energy.put("sdEnergyDay",100);
            energy.put("jnEnergyDay",100);
            energy.put("totalEnergyDay",200);
            //当月
            //手动运行时间-月
            energy.put("sdSystemRunningTimeMonth",sysSystemParams.getSdSystemRunningTimeMonth());
            //节能运行时间-月
            energy.put("jnSystemRunningTimeMonth",sysSystemParams.getJnSystemRunningTimeMonth());
            energy.put("sdEnergyMonth",1000);
            energy.put("jnEnergyMonth",1000);
            energy.put("totalEnergyMonth",2000);
            map.put("energy",energy);

            //能耗统计
            List<List<String>> list = new ArrayList<List<String>>();
            //当天
            List<Map<String,Object>> listHour = totalHourService.queryList(DateUtil.getStringOfFirstDay(DateUtil.getNowFormateDate()),
                    DateUtil.getStringOfLastDay(DateUtil.getNowFormateDate()));
            for (int i = 0; i < listHour.size(); i++) {
                List<String> listDetail = new ArrayList<String>();
                listDetail.add(DateUtils.format((Date) listHour.get(i).get("create_time"),"yyyy-MM-dd HH:mm:ss"));
                listDetail.add(listHour.get(i).get("electric_energy").toString());
                list.add(listDetail);
            }

            List<List<String>> listMonth = new ArrayList<List<String>>();
            //当月
            List<Map<String,Object>> listDay = totalDayService.queryList(DateUtil.getStringOfFirstDay(DateUtil.getStringOfFirstDayInMonth()),
                    DateUtil.getStringOfLastDay(DateUtil.getStringOfLastDayInMonth()));
            for (int i = 0; i < listDay.size(); i++) {
                List<String> listDetail = new ArrayList<String>();
                listDetail.add(DateUtils.format((Date) listDay.get(i).get("create_time"),"yyyy-MM-dd HH:mm:ss"));
                listDetail.add(listDay.get(i).get("electric_energy").toString());
                listMonth.add(listDetail);
            }

            map.put("energyList",list);
            map.put("energyListMonth",listMonth);
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public List<List<String>> getEnergyListTb(String resourceId, String startTime,String endTime, String resourceType) {
        Page<Map<String, Object>> page = new Page<>();
        Map<String,Object> params = new HashMap<>(16);
        params.put("resourceId",resourceId);
        params.put("startTime",DateUtil.getStringOfFirstDay(startTime));
        params.put("endTime",DateUtil.getStringOfLastDay(endTime));
        Page<Map<String,Object>> pageTask = new Page<Map<String, Object>>(Constants.INT_1, Constants.INT_99);
        if(Constants.ID_PFJ.equals(resourceType)){
            page = pfjInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_JFKTP.equals(resourceType)){
            page = jfktpInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_JLM.equals(resourceType)){

        }else if(Constants.ID_FLRBJZ.equals(resourceType)){
            page = flrbInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_SLJFG.equals(resourceType)){

        }else if(Constants.ID_SLSWJ.equals(resourceType)){
            page = dlswjInfoService.queryPageListByParam(pageTask,params);
        }else if(Constants.ID_SLJFG.equals(resourceType)){
            page = sljfgInfoService.queryPageListByParam(pageTask,params);
        }

        List<List<String>> listTj = new ArrayList<List<String>>();
        for (int i = 0; i < page.getRecords().size(); i++) {
            List<String> listDetail = new ArrayList<String>();
            listDetail.add(DateUtils.format((Date) page.getRecords().get(i).get("create_time"),"yyyy-MM-dd HH:mm:ss"));
            listDetail.add(page.getRecords().get(i).get("electric_energy").toString());
            listTj.add(listDetail);
        }
        return listTj;
    }

    @Override
    public List<List<String>> getEnergyListFx(String startTime,String endTime, String resourceType) {
        List<Map<String,Object>> list = new ArrayList<>();
        if(Constants.STRING_1.equals(resourceType)){
            int type = DateUtil.checkTimeToType(startTime,endTime);
            if(type == Constants.INT_1){
                list = totalHourService.queryList(startTime,endTime);
            }else if(type == Constants.INT_2 || type == Constants.INT_3){
                list = totalDayService.queryList(startTime,endTime);
            }else if(type == Constants.INT_4){
                list = totalMonthService.queryList(startTime,endTime);
            }
        }else if(Constants.ID_PFJ.equals(resourceType)){
            list = pfjInfoService.queryListByParam(startTime,endTime);
        }else if(Constants.ID_JFKTP.equals(resourceType)){
            list = jfktpInfoService.queryListByParam(startTime,endTime);
        }else if(Constants.ID_JLM.equals(resourceType)){

        }else if(Constants.ID_FLRBJZ.equals(resourceType)){
            list = flrbInfoService.queryListByParam(startTime,endTime);
        }else if(Constants.ID_SLJFG.equals(resourceType)){
            list = sljfgInfoService.queryListByParam(startTime,endTime);
        }else if(Constants.ID_SLSWJ.equals(resourceType)){
            list = dlswjInfoService.queryListByParam(startTime,endTime);
        }

        List<List<String>> listTj = new ArrayList<List<String>>();
        for (int i = 0; i < list.size(); i++) {
            List<String> listDetail = new ArrayList<String>();
            listDetail.add(DateUtils.format((Date) list.get(i).get("create_time"),"yyyy-MM-dd HH:mm:ss"));
            listDetail.add(list.get(i).get("electric_energy").toString());
            listTj.add(listDetail);
        }
        return listTj;
    }
}
