package com.devplatform.admin.modules.eq.service.impl;

import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.modules.eq.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备的service接口实现类
 * @author dxw
 */
@Service("equipmentService")
public class EquipmentServiceImpl implements EquipmentService {
    @Autowired
    private DlsnjInfoService dlsnjInfoService;
    @Autowired
    private DlswjInfoService dlswjInfoService;
    @Autowired
    private FlrbInfoService flrbInfoService;
    @Autowired
    private JfktpInfoService jfktpInfoService;
    @Autowired
    private PfjInfoService pfjInfoService;
    @Autowired
    private SbInfoService sbInfoService;
    @Autowired
    private SljfgInfoService sljfgInfoService;
    @Autowired
    private SnqxzInfoService snqxzInfoService;
    @Autowired
    private SwqxzInfoService swqxzInfoService;
    @Autowired
    private AnalysisService analysisService;
    @Autowired
    private SnqxzInfoHourService snqxzInfoHourService;
    @Autowired
    private DlxfsnjInfoService dlxfsnjInfoService;

    @Override
    public Map<String, Object> getList() {
        Map<String,Object> map = new HashMap<String,Object>(32);
        //多联室内机
        List<Map<String,Object>> dlsnjList = dlsnjInfoService.getList();
        //多联室外机
        List<Map<String,Object>> dlswjList = dlswjInfoService.getList();
        //风冷热泵机组
        List<Map<String,Object>> flrbList = flrbInfoService.getList();
        //机房空调
        List<Map<String,Object>> jfktpList = jfktpInfoService.getList();
        //排风机
        List<Map<String,Object>> pfjList = pfjInfoService.getList();
        //水泵
        List<Map<String,Object>> sbList = sbInfoService.getList();
        //室内机风柜
        List<Map<String,Object>> sljfgList = sljfgInfoService.getList();
        //室内气象站
        List<Map<String,Object>> snqxzList = snqxzInfoService.getList();
        //室外气象站
        List<Map<String,Object>> swqxzList = swqxzInfoService.getList();
        //多联新风处理机室内机
        List<Map<String,Object>> dlxfsnjList = dlxfsnjInfoService.getList();

        List<Map<String,Object>> snqxMaps = snqxzInfoHourService.getParamGroupByRegion(null);
        for(Map<String,Object> temp : snqxMaps ){
            if(Constants.STRING_1.equals(temp.get("region").toString())){
                //候车大厅室内
                map.put("hcdtSnqx",temp);
            }else if(Constants.STRING_2.equals(temp.get("region").toString())){
                //办公区域室内
                map.put("bgqySnqx",temp);
            }
        }
        //多联室内机
        map.put("dlsnjList",dlsnjList);
        //多联室外机
        map.put("dlswjList",dlswjList);
        //风冷热泵机组
        map.put("flrbList",flrbList);
        //机房空调(220V)
        map.put("jfktpList",jfktpList);
        //排风机
        map.put("pfjList",pfjList);
        //水泵
        map.put("sbList",sbList);
        //室内机风柜
        map.put("sljfgList",sljfgList);
        //室内气象站
        map.put("snqxzList",snqxzList);
        //室外气象站
        map.put("swqxzList",swqxzList);
        //多联新风处理机室内机
        map.put("dlxfsnjList",dlxfsnjList);
        //首页数据
        map.put("syBean",analysisService.getSyParam());
        return map;
    }
}
