package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.modules.eq.bean.FlrbInfo;
import com.devplatform.admin.modules.eq.dao.FlrbInfoDao;
import com.devplatform.admin.modules.eq.model.FlrbInfoModel;
import com.devplatform.admin.modules.eq.service.FlrbInfoDayService;
import com.devplatform.admin.modules.eq.service.FlrbInfoHourService;
import com.devplatform.admin.modules.eq.service.FlrbInfoMonthService;
import com.devplatform.admin.modules.eq.service.FlrbInfoService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 风冷热泵机组信息的service接口实现类
 * <br>
 * <b>功能：</b>FlrbInfoServiceImpl<br>
 * @author 代码生成器产生
 */
@Service("flrbInfoService")
public class FlrbInfoServiceImpl extends MyBaseServiceImpl<FlrbInfoDao, FlrbInfo> implements FlrbInfoService {
    @Autowired
    private FlrbInfoHourService flrbInfoHourService;
    @Autowired
    private FlrbInfoDayService flrbInfoDayService;
    @Autowired
    private FlrbInfoMonthService flrbInfoMonthService;

    @Override
    public List<FlrbInfo> queryPageList(FlrbInfoModel model) {
        Integer rowCount = baseMapper.queryPageByCount(model);
        model.getPager().setRowCount(rowCount);
        return baseMapper.queryPageList(model);
    }

    @Override
    public List<Map<String, Object>> getList() {
        return baseMapper.getList();
    }

    @Override
    public Page<Map<String, Object>> queryPageListByParam(Page<Map<String, Object>> pageTask, Map<String, Object> params) {
        String startTime = (String) params.get("startTime");
        String endTime = (String) params.get("endTime");
        int type = DateUtil.checkTimeToType(startTime,endTime);
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        if(type == Constants.INT_1){
            page = flrbInfoHourService.queryPageListByParam(pageTask,params);
        }else if(type == Constants.INT_2 || type == Constants.INT_3){
            page = flrbInfoDayService.queryPageListByParam(pageTask,params);
        }else if(type == Constants.INT_4){
            page = flrbInfoMonthService.queryPageListByParam(pageTask,params);
        }
        return page;
    }

    @Override
    public List<Map<String, Object>> queryListByParam(String startTime,String endTime) {
        List<Map<String,Object>> list = new ArrayList<>();
        int type = DateUtil.checkTimeToType(startTime,endTime);
        if(type == Constants.INT_1){
            list = flrbInfoHourService.queryListByParam(startTime,endTime);
        }else if(type == Constants.INT_2 || type == Constants.INT_3){
            list = flrbInfoDayService.queryListByParam(startTime,endTime);
        }else if(type == Constants.INT_4){
            list = flrbInfoMonthService.queryListByParam(startTime,endTime);
        }
        return list;
    }

}
