package com.devplatform.admin.modules.eq.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.modules.eq.bean.SljfgInfo;
import com.devplatform.admin.modules.eq.dao.SljfgInfoDao;
import com.devplatform.admin.modules.eq.model.SljfgInfoModel;
import com.devplatform.admin.modules.eq.service.SljfgInfoDayService;
import com.devplatform.admin.modules.eq.service.SljfgInfoHourService;
import com.devplatform.admin.modules.eq.service.SljfgInfoMonthService;
import com.devplatform.admin.modules.eq.service.SljfgInfoService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 室内机风柜信息的service接口实现类
 * <br>
 * <b>功能：</b>SljfgInfoServiceImpl<br>
 * @author 代码生成器产生
 */
@Service("sljfgInfoService")
public class SljfgInfoServiceImpl extends MyBaseServiceImpl<SljfgInfoDao, SljfgInfo> implements SljfgInfoService {
    @Autowired
    private SljfgInfoHourService sljfgInfoHourService;
    @Autowired
    private SljfgInfoDayService sljfgInfoDayService;
    @Autowired
    private SljfgInfoMonthService sljfgInfoMonthService;

    @Override
    public List<SljfgInfo> queryPageList(SljfgInfoModel model) {
        Integer rowCount = baseMapper.queryPageByCount(model);
        model.getPager().setRowCount(rowCount);
        return baseMapper.queryPageList(model);
    }

    @Override
    public List<Map<String, Object>> getList() {
        return baseMapper.getList();
    }

    @Override
    public Page<Map<String, Object>> queryPageListByParam(Page<Map<String, Object>> pageTask, Map<String, Object> params) {
        String startTime = (String) params.get("startTime");
        String endTime = (String) params.get("endTime");
        int type = DateUtil.checkTimeToType(startTime,endTime);
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        if(type == Constants.INT_1){
            page = sljfgInfoHourService.queryPageListByParam(pageTask,params);
        }else if(type == Constants.INT_2 || type == Constants.INT_3){
            page = sljfgInfoDayService.queryPageListByParam(pageTask,params);
        }else if(type == Constants.INT_4){
            page = sljfgInfoMonthService.queryPageListByParam(pageTask,params);
        }
        return page;
    }

    @Override
    public List<Map<String, Object>> queryListByParam(String startTime,String endTime) {
        List<Map<String,Object>> list = new ArrayList<>();
        int type = DateUtil.checkTimeToType(startTime,endTime);
        if(type == Constants.INT_1){
            list = sljfgInfoHourService.queryListByParam(startTime,endTime);
        }else if(type == Constants.INT_2 || type == Constants.INT_3){
            list = sljfgInfoDayService.queryListByParam(startTime,endTime);
        }else if(type == Constants.INT_4){
            list = sljfgInfoMonthService.queryListByParam(startTime,endTime);
        }
        return list;
    }

}
