package com.devplatform.admin.modules.generation.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.modules.generation.bean.CreateJavaModel;
import com.devplatform.admin.modules.generation.util.CustomException;
import com.devplatform.admin.modules.generation.util.DbConnectionUtil;
import com.devplatform.admin.modules.generation.util.FieldModel;
import com.devplatform.admin.modules.generation.util.FtlUtil;
import com.devplatform.admin.modules.generation.util.GeneratorConstant;
import com.devplatform.admin.modules.generation.util.JdbcQueryUtil;
import com.devplatform.admin.modules.generation.util.ValidateUtil;
import com.devplatform.common.controller.BaseController;
import com.devplatform.common.util.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"代码生成接口"})
@PropertySource("classpath:/createJava.properties")
@RestController
@RequestMapping("/createjava")
public class CreateJavaAction extends BaseController {

  private static Log log = LogFactory.getLog(CreateJavaAction.class);

  @Value("${gpt.java.devPath}")
  private String javaDevPath;

  @Value("${gpt.xml.devPath}")
  private String xmlDevPath;

  @Value("${gpt.template.devPath}")
  private String templateDevPath;

  @Value("${gpt.url}")
  private String defaultUrl;

  private static String getPortFromUrl(String source) {
    if (ValidateUtil.isNotEmpty(source)) {
      String[] temp = source.split(":");
      if (temp != null && temp.length == Constants.INT_4) {
        return temp[3].split("/")[0];
      }
    }
    return source;
  }

  private static String getDbFromUrl(String source) {
    if (ValidateUtil.isNotEmpty(source)) {
      String[] temp = source.split(":");
      if (temp != null && temp.length == Constants.INT_4) {
        return temp[3].split("/")[1];
      }
    }
    return source;
  }

  /**
   * @return
   * @throws Exception
   */
  @ApiOperation(value = "获取数据库数据", notes = "获取数据库数据")
  @GetMapping("/list")
  public R list() throws Exception {
    Map<String, Object> context = new HashMap<>(10);
    String defaultIp = getIpFromUrl(defaultUrl);
    String defaultPort = getPortFromUrl(defaultUrl);
    String defaultDb = getDbFromUrl(defaultUrl);
    // 设置页面数据
    context.put("defaultIp", defaultIp);
    context.put("defaultPort", defaultPort);
    context.put("defaultDb", defaultDb);
    context.put("javaDevPath", javaDevPath);
    context.put("xmlDevPath", xmlDevPath);
    return R.ok(context);
  }

  /**
   * @param model
   * @return
   * @throws Exception
   */
  @ApiOperation(value = "验证并获取表信息", notes = "验证并获取表信息")
  @PostMapping("/viewTable")
  public Map<String, Object> viewTable(
      @RequestBody @ApiParam(value = "代码生成实体", required = true) CreateJavaModel model)
      throws Exception {
    Map<String, Object> context = new HashMap<>(16);
    String tableSql =
        "select distinct column_name, data_type, column_comment, ordinal_position, column_key, is_nullable, character_maximum_length max_length from information_schema.columns c where table_name = ? and table_schema = ? group by column_name order by ordinal_position asc";
    Connection conn = null;
    if (model.getDbType() == 1) {
      String url =
          "jdbc:mysql://_ip_:_port_/_dbName_?useUnicode=true&amp;charaterEncoding=utf-8&amp;autoReconnect=true";
      url =
          url.replaceAll("_ip_", model.getIp())
              .replaceAll("_port_", model.getPort())
              .replaceAll("_dbName_", model.getDbName());
      try {
        conn = DbConnectionUtil.getMysqlConnection(url, model.getUsername(), model.getDbpwd());
        context.put(GeneratorConstant.SUCCESS, true);
        context.put(GeneratorConstant.MSG, "验证成功");

        context = s(model, context, tableSql, conn);
      } catch (Exception e) {
        context.put(GeneratorConstant.SUCCESS, false);
        context.put(GeneratorConstant.MSG, e.toString());
      } finally {
        if (null != conn) {
          conn.close();
        }
      }
    }
    return getR(context);
  }

  private Map<String, Object> s(
      CreateJavaModel model, Map<String, Object> context, String tableSql, Connection conn) {
    if (model.getCurrentIndex() != null && Constants.STRING_1.equals(model.getCurrentIndex())) {
      return context;
    } else {
      List<Map<String, Object>> results =
          JdbcQueryUtil.commonQueryList(conn, tableSql, model.getTableName(), model.getDbName());
      if (!results.isEmpty()) {
        for (Map<String, Object> result : results) {
          result.put("MAX_LENGTH", result.get("CHARACTER_MAXIMUM_LENGTH"));
        }
        context.put(GeneratorConstant.DATA, results);
        context.put(GeneratorConstant.SUCCESS, true);
        context.put(GeneratorConstant.MSG, "验证成功");
      } else {
        context.put(GeneratorConstant.SUCCESS, false);
        context.put(GeneratorConstant.MSG, "没有此表");
      }
    }
    return context;
  }

  private Map<String, Object> getR(Map<String, Object> context) {
    if ((boolean) context.get(GeneratorConstant.SUCCESS)) {
      return R.ok(context);
    } else {
      return R.error(context.get(GeneratorConstant.MSG).toString());
    }
  }

  private String getIpFromUrl(String source) {
    if (ValidateUtil.isNotEmpty(source)) {
      String[] temp = source.split(":");
      if (temp != null && temp.length == Constants.INT_4) {
        return temp[2].replaceAll("//", "");
      }
    }

    return source;
  }

  private String mysqlDbUrl(CreateJavaModel model) {
    String url =
        "jdbc:mysql://_ip_:_port_/_dbName_?useUnicode=true&amp;charaterEncoding=utf-8&amp;autoReconnect=true";
    url =
        url.replaceAll("_ip_", model.getIp())
            .replaceAll("_port_", model.getPort())
            .replaceAll("_dbName_", model.getDbName());
    return url;
  }

  private List<FieldModel> getFieldsFromJson(String jsonString) {
    if (ValidateUtil.isEmpty(jsonString)) {
      return Collections.emptyList();
    }
    JSONArray jsonArray = null;
    try {
      jsonArray = JSONArray.parseArray(jsonString);
    } catch (Exception e) {
      log.error(e);
    }
    if (jsonArray == null) {
      return Collections.emptyList();
    }

    List<FieldModel> fields = new ArrayList<>();
    for (int i = 0; i < jsonArray.size(); i++) {
      JSONObject x = (JSONObject) jsonArray.get(i);
      FieldModel field = new FieldModel();
      judge(x, field);
      fields.add(field);
    }
    return fields;
  }

  private void judge(JSONObject x, FieldModel field) {
    if (x.containsKey(GeneratorConstant.IS_NULLABLE)) {
      field.setCanBeNull(x.getString(GeneratorConstant.IS_NULLABLE));
    }
    if (x.containsKey(GeneratorConstant.ENUMAT)) {
      field.setEnumString(x.getString(GeneratorConstant.ENUMAT));
    }
    if (x.containsKey(GeneratorConstant.COLUMN_NAME)) {
      field.setFieldName(x.getString(GeneratorConstant.COLUMN_NAME));
    }
    if (x.containsKey(GeneratorConstant.COLUMN_COMMENT)) {
      field.setFieldRemark(x.getString(GeneratorConstant.COLUMN_COMMENT));
    }
    if (x.containsKey(GeneratorConstant.DATA_TYPE)) {
      field.setFieldType(x.getString(GeneratorConstant.DATA_TYPE));
    }
    if (x.containsKey(GeneratorConstant.IS_EMAIL)) {
      field.setIsEmail(x.getString(GeneratorConstant.IS_EMAIL));
    }
    if (x.containsKey(GeneratorConstant.IS_IDNO)) {
      field.setIsIdNo(x.getString(GeneratorConstant.IS_IDNO));
    }
    if (x.containsKey(GeneratorConstant.IS_MOBILE)) {
      field.setIsMobile(x.getString(GeneratorConstant.IS_MOBILE));
    }
    if (x.containsKey(GeneratorConstant.MAX_LENGTH)) {
      String t = x.getString(GeneratorConstant.MAX_LENGTH);
      if (ValidateUtil.isNotEmpty(t)) {
        field.setMaxLength(Integer.parseInt(t));
      }
    }
    if (x.containsKey(GeneratorConstant.MIN_LENGTH)) {
      String t = x.getString(GeneratorConstant.MIN_LENGTH);
      if (ValidateUtil.isNotEmpty(t)) {
        field.setMaxLength(Integer.parseInt(t));
      }
    }
    if (x.containsKey(GeneratorConstant.REGEX)) {
      field.setRegexString(x.getString(GeneratorConstant.REGEX));
    }
  }

  /**
   * 生成文件
   *
   * @param model
   * @return
   */
  @ApiOperation(value = "生成文件", notes = "生成文件")
  @PostMapping("/createFile")
  public R createFile(
      @RequestBody @ApiParam(value = "代码生成实体", required = true) CreateJavaModel model) {
    String returnString = "生成成功，请查看";
    // 拼接数据库连接字符串
    mysqlDbUrl(model);
    model.setPfix(ResourceBundle.getBundle("createJava").getString("gpt.pfix"));
    model.setFields(getFieldsFromJson(model.getJsonString()));
    model.setTemplateFolder(templateDevPath + "template");
    javaDevPath = model.getJavaDevPath();
    xmlDevPath = model.getXmlDevPath();
    create(model);
    return R.ok(returnString);
  }

  public void create(CreateJavaModel model) {
    if (Boolean.parseBoolean(model.getIsBean())) {
      createBean(model);
    }
    if (Boolean.parseBoolean(model.getIsController())) {
      createController(model);
    }
    if (Boolean.parseBoolean(model.getIsMapperJava())) {
      createMapperJava(model);
    }
    if (Boolean.parseBoolean(model.getIsMapperXml())) {
      createMapperXml(model);
    }
    if (Boolean.parseBoolean(model.getIsService())) {
      createService(model);
      createServiceImpl(model);
    }
    if (Boolean.parseBoolean(model.getIsModel())) {
      createModel(model);
    }
  }

  private void createService(CreateJavaModel model) {
    Map<String, Object> root = new HashMap<>(5);
    root.put("bean", model);
    String content = FtlUtil.analysisTemplate(model.getTemplateFolder(), "TempService.java", root);
    content = content.replace("_#_", "$");
    writeFile(
        createFile(
            javaDevPath
                + GeneratorConstant.FGF
                + model.getModulesName()
                + GeneratorConstant.FGF
                + "service"
                + GeneratorConstant.FGF,
            model.getClassName() + "Service",
            "java"),
        content);
  }

  private void createServiceImpl(CreateJavaModel model) {
    Map<String, Object> root = new HashMap<>(5);
    root.put("bean", model);
    String content =
        FtlUtil.analysisTemplate(model.getTemplateFolder(), "TempServiceImpl.java", root);
    content = content.replace("_#_", "$");
    writeFile(
        createFile(
            javaDevPath
                + GeneratorConstant.FGF
                + model.getModulesName()
                + GeneratorConstant.FGF
                + "service"
                + GeneratorConstant.FGF
                + "impl"
                + GeneratorConstant.FGF,
            model.getClassName() + "ServiceImpl",
            "java"),
        content);
  }

  private void createMapperXml(CreateJavaModel model) {
    Map<String, Object> root = new HashMap<>(5);
    root.put("bean", model);
    String content = FtlUtil.analysisTemplate(model.getTemplateFolder(), "TempMapper.xml", root);
    content = content.replace("_$_", "$");
    content = content.replace("_#_", "#");
    writeFile(
        createFile(
            xmlDevPath
                + "mapper"
                + GeneratorConstant.FGF
                + model.getModulesName()
                + GeneratorConstant.FGF,
            model.getClassName() + "Mapper",
            "xml"),
        content);
  }

  private void createMapperJava(CreateJavaModel model) {
    Map<String, Object> root = new HashMap<>(5);
    root.put("bean", model);
    String content = FtlUtil.analysisTemplate(model.getTemplateFolder(), "TempMapper.java", root);
    content = content.replace("_#_", "$");
    writeFile(
        createFile(
            javaDevPath
                + GeneratorConstant.FGF
                + model.getModulesName()
                + GeneratorConstant.FGF
                + "dao"
                + GeneratorConstant.FGF,
            model.getClassName() + "Dao",
            "java"),
        content);
  }

  private void createController(CreateJavaModel model) {
    Map<String, Object> root = new HashMap<>(5);
    root.put("bean", model);
    String content =
        FtlUtil.analysisTemplate(model.getTemplateFolder(), "TempController.java", root);
    content = content.replace("_#_", "$");
    writeFile(
        createFile(
            javaDevPath
                + GeneratorConstant.FGF
                + model.getModulesName()
                + GeneratorConstant.FGF
                + "controller"
                + GeneratorConstant.FGF,
            model.getClassName() + "Controller",
            "java"),
        content);
  }

  private void createBean(CreateJavaModel model) {
    Map<String, Object> root = new HashMap<>(5);
    root.put("bean", model);
    String content = FtlUtil.analysisTemplate(model.getTemplateFolder(), "TempBean.java", root);
    content = content.replace("_#_", "$");
    writeFile(
        createFile(
            javaDevPath
                + GeneratorConstant.FGF
                + model.getModulesName()
                + GeneratorConstant.FGF
                + "bean"
                + GeneratorConstant.FGF,
            model.getClassName(),
            "java"),
        content);
  }

  private void createModel(CreateJavaModel model) {
    Map<String, Object> root = new HashMap<>(5);
    root.put("bean", model);
    String content = FtlUtil.analysisTemplate(model.getTemplateFolder(), "TempModel.java", root);
    content = content.replace("_#_", "$");
    writeFile(
        createFile(
            javaDevPath
                + GeneratorConstant.FGF
                + model.getModulesName()
                + GeneratorConstant.FGF
                + "model"
                + GeneratorConstant.FGF,
            model.getClassName() + "Model",
            "java"),
        content);
  }

  private void writeFile(File beanFile, String content) {
    try (BufferedWriter bw =
        new BufferedWriter(new OutputStreamWriter(new FileOutputStream(beanFile), "UTF-8"))) {
      bw.write(content);
      bw.flush();
    } catch (Exception e) {
      log.error(e);
      throw new CustomException("文件出错", "0102");
    }
  }

  private File createFile(String targetPath, String fileName, String fileExt) {
    File folder = new File(targetPath);
    if (!folder.exists()) {
      folder.mkdirs();
    }
    File beanFile = new File(targetPath, fileName + "." + fileExt);
    try {
      boolean boo = beanFile.createNewFile();
      if (!boo) {
        log.error("文件生成失败");
      }
    } catch (IOException e) {
      log.error(e);
      throw new CustomException("文件出错", "0102");
    }
    return beanFile;
  }
}
