package com.devplatform.admin.modules.generation.util;

import com.devplatform.common.base.exception.RRException;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Administrator
 */
public class DbConnectionUtil {

  private static Log log = LogFactory.getLog(DbConnectionUtil.class);

  private DbConnectionUtil() {}

  public static Connection getMysqlConnection(String url, String user, String password) {
    Connection conn = null;
    try {
      Class.forName("com.mysql.jdbc.Driver");
      // 获取连接
      conn = DriverManager.getConnection(url, user, password);
      return conn;
    } catch (ClassNotFoundException e) {
      log.error(e);
      throw new RRException("没有找到数据库驱动", e);
    } catch (Exception e) {
      log.error(e);
      throw new RRException("数据库连接异常", e);
    }
  }
}
