package com.devplatform.admin.modules.generation.util;

import com.devplatform.common.base.exception.RRException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Administrator
 */
public class JdbcQueryUtil {
  private static Log log = LogFactory.getLog(JdbcQueryUtil.class);

  private JdbcQueryUtil() {
    throw new IllegalStateException("Utility class");
  }

  public static List<Map<String, Object>> commonQueryList(
      Connection conn, String sql, Object... args) {
    List<Map<String, Object>> result = new ArrayList<>();
    PreparedStatement ps = null;
    try {
      ps = conn.prepareStatement(sql);
      if (args != null && args.length > 0) {
        int parameterIndex = 1;
        for (Object arg : args) {
          ps.setObject(parameterIndex, arg);
          parameterIndex++;
        }
      }
      resultSet(ps, result);
    } catch (Exception e) {
      log.error(e);
      throw new RRException(e.getMessage(), e);
    } finally {
      try {
        if (null != ps) {
          ps.close();
        }
      } catch (SQLException e) {
        log.error(e);
      }
    }

    return result;
  }

  private static void resultSet(PreparedStatement ps, List<Map<String, Object>> result) {
    ResultSet rs = null;
    try {
      rs = ps.executeQuery();
      ResultSetMetaData md = rs.getMetaData();
      int count1 = md.getColumnCount();
      while (rs.next()) {
        Map<String, Object> rowData = new HashMap<>(count1);
        for (int i = 1; i <= count1; i++) {
          rowData.put(md.getColumnName(i), rs.getObject(i));
        }
        result.add(rowData);
      }
    } catch (Exception e) {
      log.error(e);
    } finally {
      try {
        if (null != rs) {
          rs.close();
        }
      } catch (SQLException e) {
        log.error(e);
      }
    }
  }
}
