package com.devplatform.admin.modules.liresource.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Administrator
 */
@ApiModel(value = "线路站点管理表对象", description = "线路站点管理表对象")
@TableName("li_station")
@Data
public class LiStation implements Serializable {
  /** */
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "主键ID", name = "id")
  @TableId
	/** 主键id*/
  private java.lang.String id; 

  @ApiModelProperty(value = "车站名称", name = "stationName")
	/** 车站名称*/
  private java.lang.String stationName; 

  @ApiModelProperty(value = "车站编号", name = "code")
	/** 车站编号*/
  private java.lang.String code; 

  @ApiModelProperty(value = "简称", name = "shortName")
	/** 简称*/
  private java.lang.String shortName; 

  @ApiModelProperty(value = "地图X坐标", name = "x")
	/** 地图X坐标*/
  private java.lang.String x; 

  @ApiModelProperty(value = "地图y坐标", name = "y")
	/** 地图y坐标*/
  private java.lang.String y; 

  @ApiModelProperty(value = "位置", name = "location")
	/** 位置*/
  private java.lang.String location; 

  @ApiModelProperty(value = "图标地址", name = "icon")
	/** 图标地址*/
  private java.lang.String icon; 

  @ApiModelProperty(value = "站点类型(1正线车站，2换乘车站)", name = "type")
	/** 站点类型(1正线车站，2换乘车站)*/
  private java.lang.String type; 

  @ApiModelProperty(value = "站点描述", name = "remark")
	/** 站点描述*/
  private java.lang.String remark; 

  @ApiModelProperty(value = "是否主站(1主站，2从站)", name = "isMaster")
	/** 是否主站(1主站，2从站)*/
  private Integer isMaster; 

  @ApiModelProperty(value = "排序值", name = "orderNum")
	/** 排序值*/
  private Integer orderNum; 

  @ApiModelProperty(value = "系统标识", name = "sysSign")
	/** 系统标识*/
  private java.lang.String sysSign; 

  @ApiModelProperty(value = "系统标识", name = "sysSign")
	/** 站点ID*/
  private java.lang.String stationId; 

  @ApiModelProperty(value = "状态(1正常，0不可用)", name = "status")
	/** 状态(1正常，0不可用)*/
  private Integer status; 

  @ApiModelProperty(value = "是否已删除（0未删除，1已删除）", name = "deleted")
	/** 是否已删除（0未删除，1已删除）*/
  private Integer deleted; 

  @ApiModelProperty(value = "创建人", name = "createUserId")
	/** 创建人*/
  private java.lang.String createUserId; 

  @ApiModelProperty(value = "创建时间", name = "createTime")
	/** 创建时间*/
  private java.util.Date createTime; 

  @ApiModelProperty(value = "修改人", name = "updateUserId")
	/** 修改人*/
  private java.lang.String updateUserId; 

  @ApiModelProperty(value = "修改时间", name = "updateTime")
	/** 修改时间*/
  private java.util.Date updateTime; 

  @ApiModelProperty(value = "备用项1", name = "byx1")
	/** 备用项1*/
  private java.lang.String byx1; 

  @ApiModelProperty(value = "备用项2", name = "byx2")
	/** 备用项2*/
  private java.lang.String byx2; 

  @ApiModelProperty(value = "备用项3", name = "byx3")
	/** 备用项3*/
  private java.lang.String byx3; 

  @ApiModelProperty(value = "地铁线路图横坐标", name = "coordinateX")
	/** 地铁线路图横坐标*/
  private Integer coordinateX; 

  @ApiModelProperty(value = "地铁线路图纵坐标", name = "coordinateY")
	/** 地铁线路图纵坐标*/
  private Integer coordinateY; 

  @ApiModelProperty(value = "地铁线路图站点名称显示位置(1上，2下，3左，4右)", name = "textPosition")
	/** 地铁线路图站点名称显示位置(1上，2下，3左，4右)*/
  private Integer textPosition; 

  @ApiModelProperty(value = "地铁线路图线路颜色", name = "lineColor")
	/** 地铁线路图线路颜色*/
  private String lineColor; 

  @ApiModelProperty(value = "地铁线路编号", name = "lineCode")
	/** 地铁线路编号*/
  private String lineCode; 

  @TableField(exist = false)
	/** 站点地图*/
  private List<LiStationMap> mapList; 

}
