package com.devplatform.admin.modules.liresource.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.modules.liresource.bean.LiResourcePoints;
import com.devplatform.admin.modules.liresource.model.LiResourcePointsModel;
import com.devplatform.admin.modules.liresource.service.LiResourcePointsService;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <br>
 * <b>功能：</b>LiResourcePointsController<br>
 * @author 代码生成器产生
 */
@Api(tags={"点位维护表接口"})
@RestController
@RequestMapping("/liResourcePoints")
public class LiResourcePointsController extends AbstractController{
	
	@Autowired
	private LiResourcePointsService liResourcePointsService;

	/**
	 * 列表页面列表数据获取
	 * @param params 承接对象
	 * @return
	 */
	@ApiOperation(value="根据条件获取点位维护表分页数据列表", notes="根据条件获取点位维护表分页数据列表")
	@ApiImplicitParam(name = "params", value = "参数", required = true, dataType = "Map<String, Object>")
	@PostMapping("/list")
	public R list(@RequestParam Map<String, Object> params) {
		//分页查询
		PageUtils page = liResourcePointsService.queryPage(params,null);
		//返回分页结果
		return R.ok().put("page", page);
	}

	/**
	 * 列表页面列表数据获取
	 * @param model 承接对象
	 * @return
	 */
	@ApiOperation(value="根据条件获取点位维护表分页数据列表", notes="根据条件获取点位维护表分页数据列表")
	@ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiResourcePointsModel")
	@PostMapping("/pageList")
	public R pageList(@RequestBody LiResourcePointsModel model) {
		//如果model参数中没有设置排序方式，则默认以创建时间倒序排列
		if(StringUtil.isEmpty(model.getSort())){
			model.setSort("create_time desc");
		}
		//按条件查询分页数据
		List<LiResourcePoints> list = liResourcePointsService.queryPageList(model);
		//将查询结果中数据和数量封装起来做为接口返回值
		return R.ok().put("page", getMyPage(list,model));
	}
	
	/**
	 * 添加
	 * @param bean 点位维护表对象
	 * @return
	 */
	@SysLog("添加点位维护表")
	@ApiOperation(value="新增点位维护表数据", notes="新增点位维护表数据")
	@PostMapping("/save")
	public R save(@RequestBody @ApiParam(value="点位维护表实体对象", required = true)LiResourcePoints bean) {
		ValidatorUtils.validateEntity(bean);
		bean.setCreateUserId(getUserId());
		bean.setCreateTime(new Date());
		liResourcePointsService.save(bean);
		return R.ok();
	}
	
	/**
	 * 修改
	 * @param bean 点位维护表对象
	 * @return
	 */
	@SysLog("修改点位维护表")
	@ApiOperation(value="修改点位维护表数据", notes="修改点位维护表数据")
	@PostMapping("/update")
	public R update(@RequestBody @ApiParam(value="点位维护表实体对象", required = true)LiResourcePoints bean) {
		ValidatorUtils.validateEntity(bean);
		bean.setUpdateUserId(getUserId());
		bean.setUpdateTime(new Date());
		liResourcePointsService.update(bean,
				new QueryWrapper<LiResourcePoints>().eq(StringUtil.checkNotNull(bean.getId()),"id", bean.getId()));
		return R.ok();
	}
	
	/**
	 * 根据ID获取点位维护表对象
	 * @param id 对象主键
	 * @return
	 */
	@ApiOperation(value="根据ID获取点位维护表对象", notes="根据ID获取点位维护表对象")
    @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
	@GetMapping("/getId/{id}")
	public R getId(@PathVariable String id) {
		LiResourcePoints bean = liResourcePointsService.getById(id);
		return R.ok().put("bean", bean);
	}
	

	/**
	 * 根据ID获取点位维护表对象
	 * @param ids 点位维护表对象主键数组
	 * @return
	 */
	@SysLog("删除点位维护表数据")
	@ApiOperation(value="根据ID批量删除点位维护表数据", notes="根据ID批量删除点位维护表数据")
    @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
	@PostMapping("/delete")
	public R delete(@RequestBody String[] ids) {
		liResourcePointsService.removeByIds(Arrays.asList(ids));
		return R.ok();
	}

	/**
	 * 逻辑删除
	 * 根据ID删除点位维护表对象
	 * @param ids 点位维护表对象主键数组
	 * @return
	 */
	@SysLog("删除点位维护表数据")
	@ApiOperation(value="根据ID批量删除点位维护表数据", notes="根据ID批量删除点位维护表数据")
	@ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String[]")
	@PostMapping("/deleteByFlag")
	public R deleteByFlag(@RequestBody String[] ids) {
		//根据id数组删除
		liResourcePointsService.deleteByFlagByIds(ids, getUserId());
		//返回成功
		return R.ok();
	}

}
