package com.devplatform.admin.modules.liresource.controller;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.modules.liresource.bean.LiStation;
import com.devplatform.admin.modules.liresource.bean.LiStationMap;
import com.devplatform.admin.modules.liresource.model.LiStationModel;
import com.devplatform.admin.modules.liresource.service.LiStationMapService;
import com.devplatform.admin.modules.liresource.service.LiStationService;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
@Api(tags = {"线路站点管理表接口"})
@RestController
@RequestMapping("/liStation")
public class LiStationController extends AbstractController {

  @Autowired private LiStationService liStationService;
  @Autowired private LiStationMapService liStationMapService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取线路站点管理表分页数据列表", notes = "根据条件获取线路站点管理表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestBody LiStationModel model) {
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("order_num");
      model.setOrder("ASC");
    }
    List<LiStation> list = liStationService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 添加
   *
   * @param bean 线路站点管理表对象
   * @return
   */
  @ApiOperation(value = "新增线路站点管理表数据", notes = "新增线路站点管理表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "线路站点管理表实体对象", required = true) LiStation bean) {
    Long startTime = System.currentTimeMillis();
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    liStationService.saveStation(bean);
    SysUserEntity user = getUser();
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 线路站点管理表对象
   * @return
   */
  @ApiOperation(value = "修改线路站点管理表数据", notes = "修改线路站点管理表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "线路站点管理表实体对象", required = true) LiStation bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    liStationService.updateStation(bean);
    return R.ok();
  }

  /**
   * 根据ID获取线路站点管理表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取线路站点管理表对象", notes = "根据ID获取线路站点管理表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id, String stationId) {
    LiStation bean = liStationService.getById(id);
    List<LiStationMap> mapList = liStationMapService.getListByStationId(id);
    bean.setMapList(mapList);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取线路站点管理表对象
   *
   * @param ids 线路站点管理表对象主键数组
   * @return
   */
  @ApiOperation(value = "根据ID批量删除线路站点管理表数据", notes = "根据ID批量删除线路站点管理表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    Long startTime = System.currentTimeMillis();
    liStationService.removeByIds(Arrays.asList(ids));
    SysUserEntity user = getUser();
    String stationId = getRequest().getHeader("stationId");
    return R.ok();
  }

  /**
   * 根据ID删除线路站点
   *
   * @param bean 线路站点管理表对象
   * @return
   */
  @ApiOperation(value = "删除线路站点管理表数据", notes = "删除线路站点管理表数据")
  @ApiImplicitParam(name = "bean", value = "线路站点管理表对象", required = true, dataType = "LiStation")
  @PostMapping("/deleteById")
  public R deleteById(
      @RequestBody @ApiParam(value = "线路站点管理表实体对象", required = true) LiStation bean) {
    Long startTime = System.currentTimeMillis();
    bean.setDeleted(1);
    bean.setUpdateTime(new Date());
    bean.setUpdateUserId(getUserId());
    bean.setSysSign(getUser().getSysSystem().getCode());
    liStationService.update(
        bean,
        new UpdateWrapper<LiStation>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
    SysUserEntity user = getUser();
    String stationId = getRequest().getHeader("stationId");
    return R.ok();
  }

  /**
   * 列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取站点管理表数据列表", notes = "根据条件获取站点管理表数据列表")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationModel")
  @PostMapping("/listAll")
  public R listAll(@RequestBody LiStationModel model) {
    model.setRows(Integer.MAX_VALUE);
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("order_num");
      model.setOrder("ASC");
    }
    List<LiStation> list = liStationService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 根据ID获取线路站点管理表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取线路站点管理表对象", notes = "根据ID获取线路站点管理表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/queryId/{id}")
  public R queryId(@PathVariable String id) {
    LiStation bean = liStationService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 站点接管列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取站点接管分页数据列表", notes = "根据条件获取站点接管分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/listTakeover")
  public R listTakeover(@RequestBody LiStationModel model) {
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("order_num");
      model.setOrder("ASC");
    }
    List<Map<String, Object>> list = liStationService.queryPageByListTakeover(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 根据ID获取软网关地址
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取线路站点管理表对象", notes = "根据ID获取线路站点管理表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/queryById")
  public String queryById(@RequestParam("id") String id) {
    LiStation bean = liStationService.getById(id);
    return bean.getByx1();
  }
}
