package com.devplatform.admin.modules.liresource.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.admin.common.annotation.SysLogMethod;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.modules.liresource.bean.LiStationMap;
import com.devplatform.admin.modules.liresource.service.LiResourceService;
import com.devplatform.admin.modules.liresource.service.LiStationMapService;
import com.devplatform.admin.modules.sys.service.SysOssService;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;

/**
 * @author Administrator
 */
@Api(tags = {"线路站点地图附件表接口"})
@RestController
@RequestMapping("/liStationMap")
public class LiStationMapController extends AbstractController {
  @Autowired private LiStationMapService liStationMapService;
  @Autowired private SysOssService sysOssService;

  @Autowired private LiResourceService liResourceService;

  @Value("${upload.realBaseDir}")
  private String realBaseDir;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取线路站点地图附件表分页数据列表", notes = "根据条件获取线路站点地图附件表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = liStationMapService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 添加
   *
   * @param bean 线路站点地图附件表对象
   * @return
   */
  @SysLogMethod(operation = "新增", blockName = "系统管理", detail = "新增线路站点地图附件数据")
  @ApiOperation(value = "新增线路站点地图附件表数据", notes = "新增线路站点地图附件表数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "线路站点地图附件表实体对象", required = true) LiStationMap bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    liStationMapService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 线路站点地图附件表对象
   * @return
   */
  @SysLogMethod(operation = "修改", blockName = "系统管理", detail = "修改线路站点地图附件数据")
  @ApiOperation(value = "修改线路站点地图附件表数据", notes = "修改线路站点地图附件表数据")
  @PostMapping("/update")
  public R update(
      @RequestBody @ApiParam(value = "线路站点地图附件表实体对象", required = true) LiStationMap bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    liStationMapService.update(
        bean,
        new QueryWrapper<LiStationMap>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId()));
    return R.ok();
  }

  /**
   * 根据ID获取线路站点地图附件表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取线路站点地图附件表对象", notes = "根据ID获取线路站点地图附件表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LiStationMap bean = liStationMapService.getById(id);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取线路站点地图附件表对象
   *
   * @param ids 线路站点地图附件表对象主键数组
   * @return
   */
  @SysLogMethod(operation = "删除", blockName = "系统管理", detail = "删除站点地图")
  @ApiOperation(value = "根据ID批量删除线路站点地图附件表数据", notes = "根据ID批量删除线路站点地图附件表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    Integer countNum = liResourceService.queryCountByTierId(ids[0]);
    if (countNum > 0) {
      return R.error("该站层下有资源点，不能删除!");
    }

    liStationMapService.deleteByIds(Arrays.asList(ids), getUser().getSysSystem().getCode());
    return R.ok();
  }

  /**
   * 上传站点地图
   *
   * @param file 文件
   * @param stationId 站点id
   * @return
   */
  @SysLogMethod(operation = "修改", blockName = "系统管理", detail = "修改站点地图")
  @ApiOperation(value = "上传站点地图", notes = "上传站点地图")
  @ApiImplicitParam(name = "file", value = "参数", required = true, dataType = "MultipartFile")
  @PostMapping("/uploadFile")
  public R uploadFile( MultipartFile file, String type, String stationId, String name, Integer orderNum, String id) {
    LiStationMap stationMap = new LiStationMap();

    String path = "";
    String savePath = "";
    try {
      // 保存附件
      savePath = sysOssService.upload(file, type, stationId);
      // 保存到数据库
      // 上传的时候不保存站点id，只有点击修改站点页面的保存页面后才保存站点id
      if (StringUtils.isNotBlank(savePath)) {
        stationMap.setFilePath(savePath);
        stationMap.setFileName(file.getOriginalFilename());
        stationMap.setDeleted(1);
        if (StringUtil.checkNotNull(id)) {
          stationMap.setId(id);
          stationMap.setUpdateTime(new Date());
          stationMap.setUpdateUserId(getUserId());
          stationMap.setSysSign(getUser().getSysSystem().getCode());
          stationMap.setStationId(stationId);
          liStationMapService.updateById(stationMap);
        } else {
          stationMap.setSysSign(getUser().getSysSystem().getCode());
          stationMap.setStationId(stationId);
          stationMap.setCreateTime(new Date());
          stationMap.setCreateUserId(getUserId());
          liStationMapService.save(stationMap);
        }
      }

      stationMap = liStationMapService.getById(stationMap.getId());
    } catch (Exception e) {
      e.printStackTrace();
    }
    return R.ok().put("bean", stationMap).put("path", path);
  }
}
