package com.devplatform.admin.modules.liresource.dao;

import com.devplatform.admin.modules.liresource.bean.LiStation;
import com.devplatform.admin.modules.liresource.model.LiStationModel;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * LiStation Mapper 用于线路站点管理表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LiStationDao extends MyBaseMapper<LiStation> {

  /**
   * 查询分页数量
   *
   * @param model
   * @return
   */
  Integer queryPageByCount(LiStationModel model);

  /**
   * 查询分页数据
   *
   * @param model
   * @return
   */
  List<LiStation> queryPageByList(LiStationModel model);

  /**
   * 查询站点树
   *
   * @param model
   * @return
   */
  List<LiStation> getTreeList(LiStationModel model);

  /**
   * 站点接管管理列表页数量
   *
   * @param model
   * @return
   */
  Integer queryPageByCountTakeover(LiStationModel model);

  /**
   * 站点接管管理列表页数据
   *
   * @param model
   * @return
   */
  List<Map<String, Object>> queryPageByListTakeover(LiStationModel model);
}
