package com.devplatform.admin.modules.liresource.dao;

import com.devplatform.admin.modules.liresource.bean.LiStationMap;
import com.devplatform.admin.modules.liresource.model.LiStationMapModel;
import com.devplatform.common.dao.MyBaseMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * LiStationMap Mapper 用于线路站点地图附件表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LiStationMapDao extends MyBaseMapper<LiStationMap> {

  /**
   * 查询站点地图
   *
   * @param model
   * @return
   */
  List<LiStationMap> getTreeList(LiStationMapModel model);

  /**
   * 逻辑删除站点地图
   * @param list
   * @param sysSign
   */
  void deleteByIds(@Param("list") List<String> list, @Param("sysSign") String sysSign);

  /**
   * 查询站点所有地图
   *
   * @param stationId
   * @return
   */
  List<LiStationMap> getListByStationId(String stationId);
}
