package com.devplatform.admin.modules.liresource.service;

import com.devplatform.admin.modules.liresource.bean.LiResource;
import com.devplatform.admin.modules.liresource.model.LiResourceModel;
import com.devplatform.common.service.MyBaseService;

import java.util.List;

/**
 * 资源点管理表的service接口 <br>
 * <b>功能：</b>LiResourceService<br>
 *
 * @author 代码生成器产生
 */
public interface LiResourceService extends MyBaseService<LiResource> {

  /**
   * 分页查询
   *
   * @param model
   * @return
   */
  List<LiResource> queryPageByList(LiResourceModel model);

  /**
   * 获取线路-站点-资源点树
   *
   * @param model
   * @return
   */
  List<LiResource> getTreeList(LiResourceModel model);

  /**
   * 根据id获取资源点信息
   * @param id
   * @param stationId
   * @return
   */
  LiResource getBeanById(String id, String stationId);

  /**
   * 根据站层id查询资源点数量
   *
   * @param tierId
   * @return
   */
  Integer queryCountByTierId(String tierId);

  /**
   * 根据资源点编号查询资源点详情
   *
   * @param code 资源点编号
   * @return 资源点详情
   */
  LiResource queryByCode(String code);

  /**
   * 查询人工模式下的所有资源点
   *
   * @param modeTypes
   * @return
   */
  List<LiResource> queryListByParam(String modeTypes);
}
