package com.devplatform.admin.modules.liresource.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.admin.modules.liresource.bean.LiStation;
import com.devplatform.admin.modules.liresource.dao.LiStationDao;
import com.devplatform.admin.modules.liresource.model.LiStationModel;
import com.devplatform.admin.modules.liresource.service.LiStationMapService;
import com.devplatform.admin.modules.liresource.service.LiStationService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 线路站点管理表的service接口实现类 <br>
 * <b>功能：</b>LiStationServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("liStationService")
public class LiStationServiceImpl extends MyBaseServiceImpl<LiStationDao, LiStation>
    implements LiStationService {
  @Autowired private LiStationMapService liStationMapService;

  @Override
  public List<LiStation> queryPageByList(LiStationModel model) {
    Integer rowCount = baseMapper.queryPageByCount(model);
    model.getPager().setRowCount(rowCount);
    return baseMapper.queryPageByList(model);
  }

  @Override
  public List<LiStation> getTreeList(LiStationModel model) {
    return baseMapper.getTreeList(model);
  }

  @Override
  public void saveStation(LiStation bean) {
    baseMapper.insert(bean);

    if (bean.getMapList() != null && bean.getMapList().size() > 0) {
      liStationMapService.saveOrUpdateBatch(bean.getId(), bean.getMapList(), bean.getSysSign());
    }
  }

  @Override
  public void updateStation(LiStation bean) {
    baseMapper.update(
        bean,
        new QueryWrapper<LiStation>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq("deleted", 0));

    if (bean.getMapList() != null && bean.getMapList().size() > 0) {
      liStationMapService.saveOrUpdateBatch(bean.getId(), bean.getMapList(), bean.getSysSign());
    }
  }

  @Override
  public List<Map<String, Object>> queryPageByListTakeover(LiStationModel model) {
    Integer rowCount = baseMapper.queryPageByCountTakeover(model);
    model.getPager().setRowCount(rowCount);
    return baseMapper.queryPageByListTakeover(model);
  }
}
