package com.devplatform.admin.modules.sys.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;

@Data
@ApiModel(value="指令日志表对象",description="指令日志表对象")
@TableName("sys_command_log")
public class SysCommandLog implements Serializable {
	private static final long serialVersionUID = 1L;

	/** 主键 */
	@ApiModelProperty(value="主键ID",name="id")
	@TableId
	private java.lang.String id;
	/** 指令来源 */
	@ApiModelProperty(value="指令来源",name="comSource")
	private Integer comSource;
	/** 指令来源IP */
	@ApiModelProperty(value="指令来源IP",name="comSourceIp")
	private java.lang.String comSourceIp;
	/** 指令来源端口 */
	@ApiModelProperty(value="指令来源端口",name="comSourcePort")
	private java.lang.String comSourcePort;
	/** 指令类型，1=自动，2=手动 */
	@ApiModelProperty(value="指令类型，1=自动，2=手动",name="comType")
	private Integer comType;
	/** 指令内容 */
	@ApiModelProperty(value="指令内容",name="comMark")
	private java.lang.String comMark;
	/** 资源点类型 */
	@ApiModelProperty(value="资源点类型",name="resourceType")
	private java.lang.String resourceType;
	/** 资源点名称 */
	@ApiModelProperty(value="资源点名称",name="resourceId")
	private java.lang.String resourceId;
	/** 执行结果 */
	@ApiModelProperty(value="执行结果",name="result")
	private Integer result;
	/** 创建时间 */
	@ApiModelProperty(value="创建时间",name="createTime")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private java.util.Date createTime;
	/** 创建人 */
	@ApiModelProperty(value="创建人",name="createUserId")
	private java.lang.String createUserId;
	/** 创建人 */
	@ApiModelProperty(value="创建人",name="createUserName")
	private java.lang.String createUserName;
	/** 是否已删除（0未删除，1已删除） */
	@ApiModelProperty(value="是否已删除（0未删除，1已删除）",name="deleted")
	private Integer deleted;
	/** 站点id */
	@ApiModelProperty(value="站点id",name="stationId")
	private java.lang.String stationId;
	/** 备用项1 */
	@ApiModelProperty(value="备用项1",name="byx1")
	private java.lang.String byx1;
	/** 备用项2 */
	@ApiModelProperty(value="备用项2",name="byx2")
	private java.lang.String byx2;
	/** 备用项3 */
	@ApiModelProperty(value="备用项3",name="byx3")
	private java.lang.String byx3;

	@TableField(exist = false)
	/** 资源点类型名称*/
	private String resourceName;
}
