package com.devplatform.admin.modules.sys.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 角色
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:27:38
 */
@ApiModel(value = "角色对象", description = "角色对象")
@TableName("sys_role")
public class SysRoleEntity implements Serializable {

  private static final long serialVersionUID = 4661206993337724898L;

  @ApiModelProperty("主键role_id")
  @TableId
  private String roleId;

  @ApiModelProperty("角色名称")
  private String roleName;

  @ApiModelProperty("备注")
  private String remark;

  @ApiModelProperty("创建者id")
  private String createUserId;

  @ApiModelProperty("创建时间")
  private Date createTime;

  @ApiModelProperty("修改人")
  private String updateUserId;

  @ApiModelProperty("修改时间")
  private Date updateTime;

  @ApiModelProperty("站点id")
  private String stationId;

  @TableField(exist = false)
  private List<String> menuIdList;

  @ApiModelProperty("是否已删除(0未删除，1已删除)")
  private Integer deleted;

  @ApiModelProperty("系统标识")
  private String sysSign;

  public String getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }

  public Date getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }

  public Integer getDeleted() {
    return deleted;
  }

  public void setDeleted(Integer deleted) {
    this.deleted = deleted;
  }

  public String getRoleId() {
    return roleId;
  }

  public void setRoleId(String roleId) {
    this.roleId = roleId;
  }

  public String getRoleName() {
    return roleName;
  }

  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public List<String> getMenuIdList() {
    return menuIdList;
  }

  public void setMenuIdList(List<String> menuIdList) {
    this.menuIdList = menuIdList;
  }
}
