package com.devplatform.admin.modules.sys.bean;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * 角色与菜单对应关系
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:28:13
 */
@ApiModel(value = "角色与菜单对应关系对象", description = "角色与菜单对应关系")
@TableName("sys_role_menu")
public class SysRoleMenuEntity implements Serializable {

  private static final long serialVersionUID = 7664680780986079950L;

  @ApiModelProperty("主键id")
  @TableId
  private String id;

  @ApiModelProperty("角色id")
  private String roleId;

  @ApiModelProperty("菜单id")
  private String menuId;

  @ApiModelProperty("系统标识")
  private String sysSign;

  @ApiModelProperty("站点id")
  private String stationId;

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getRoleId() {
    return roleId;
  }

  public void setRoleId(String roleId) {
    this.roleId = roleId;
  }

  public String getMenuId() {
    return menuId;
  }

  public void setMenuId(String menuId) {
    this.menuId = menuId;
  }
}
