package com.devplatform.admin.modules.sys.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.modules.sys.bean.SysLogEntity;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.model.SysLogModel;
import com.devplatform.admin.modules.sys.service.SysLogService;
import com.devplatform.common.util.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.Map;

/**
 * 系统日志
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2017-03-08 10:40:56
 */
@Api(tags = {"系统日志接口"})
@RestController
@RequestMapping("/sys/log")
public class SysLogController extends AbstractController {

  private static Log log = LogFactory.getLog(SysLogController.class);

  @Autowired private SysLogService sysLogService;

  /** 列表 */
  @ApiOperation(value = "根据条件获取分页数据列表", notes = "根据条件获取分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "查询参数",
      required = true,
      paramType = "query",
      dataType = "Map<String, Object>")
  @GetMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    String page = (String) params.get("page");
    String limit = (String) params.get("limit");
    SysLogModel model = new SysLogModel();
    model.setUsername((String) params.get("username"));
    model.setOperation((String) params.get("operation"));
    model.setStartTime((String) params.get("startTime"));
    model.setEndTime((String) params.get("endTime"));
    model.setStationId((String) params.get("stationId"));
    model.setSort((String) params.get("sort"));
    model.setOrder((String) params.get("order"));
    Page<SysLogEntity> pageTask =
        new Page<SysLogEntity>(Integer.parseInt(page), Integer.parseInt(limit));
    Page<SysLogEntity> page1 = sysLogService.queryPageList(pageTask, model);
    return R.ok().put("page", page1);
  }

  /** 保存日志信息,用于fegin调用 */
  @ApiOperation(value = "保存日志信息", notes = "保存日志信息")
  @PostMapping("/saveSysLog")
  public void getCurrentUserInfo(@RequestBody Map<String, Object> map) {
    if (map != null) {
      SysUserEntity user = ((SysUserEntity) SecurityUtils.getSubject().getPrincipal());
      SysLogEntity sysLog = new SysLogEntity();
      sysLog.setOperation(map.get("operation") == null ? "" : map.get("operation").toString());
      sysLog.setBlockName(map.get("blockName") == null ? "" : map.get("blockName").toString());
      sysLog.setDetail(map.get("detail") == null ? "" : map.get("detail").toString());
      sysLog.setMethod(map.get("method") == null ? "" : map.get("method").toString());
      sysLog.setParams(map.get("params") == null ? "" : map.get("params").toString());
      sysLog.setIp(map.get("ip") == null ? "" : map.get("ip").toString());
      sysLog.setStationId(
          map.get("stationId") == null
              ? user.getSysSystem().getCode()
              : map.get("stationId").toString());
      sysLog.setUsername(map.get("name") == null ? "" : map.get("name").toString());
      sysLog.setTime(map.get("time") == null ? null : Long.parseLong(map.get("time").toString()));
      sysLog.setCreateDate(new Date());
      sysLog.setCreateBy(getUserId());
      sysLog.setUserId(user.getUserId());
      sysLog.setSysSign(user.getSysSystem().getCode());
      sysLogService.save(sysLog);
    }
  }
}
