package com.devplatform.admin.modules.sys.controller;

import com.devplatform.admin.common.utils.AbstractController;
import com.devplatform.admin.modules.sys.bean.SysOss;
import com.devplatform.admin.modules.sys.service.SysOssService;
import com.devplatform.common.util.R;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
/**
 * @author Administrator
 */
@RestController
@RequestMapping("/upload")
public class UploadController extends AbstractController {

  @Autowired private SysOssService sysOssService;

  @PostMapping("/uploadFile")
  public R uploadFile(MultipartFile file, String type) {
    SysOss bean = new SysOss();
    String path = "";
    try {
      // 保存附件
      String savePath = sysOssService.upload(file, type, null);
      // 保存到数据库
      if (StringUtils.isNotBlank(savePath)) {
        bean.setCreateDate(new Date());
        bean.setUrl(savePath);
        bean.setFileName(file.getOriginalFilename());
        sysOssService.save(bean);
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    return R.ok().put("bean", bean).put("path", path);
  }

  /**
   * 上传文件
   *
   * @param type
   * @param file 文件，定义的MultipartFile
   * @return path 返回一个路径 别忘了form 加个 enctype="multipart/form-data"
   */
  //	public String upload(MultipartFile file,String type){
  //		InputStream stream = null;
  //		OutputStream bos = null;
  //		String Path = "";
  //		StringBuffer dataPath = new StringBuffer();
  //
  //		if (file!=null&&!file.isEmpty()) {
  //			// 得到该文件的后缀，判断是否允许上传
  //			String fileName=file.getOriginalFilename();
  //			String ext = fileName.substring(fileName.lastIndexOf('.') + 1,
  //					fileName.length());
  //			// 获取配置文件中的指定路径
  //			String realBaseDir = "";
  //			// 建立文件夹
  //			System.out.println(realBaseDir);
  //			File baseFile = new File(realBaseDir);
  //
  //			if (!baseFile.exists()) {
  //				baseFile.mkdirs();
  //			}
  //			// 新文件名
  //			Random ran = new Random();
  //			long num = ran.nextLong();
  //			String fileRealName = DateUtil.format(new Date(), "yyyyMMddHHmmss") + num + "dr" + "." + ext;
  //			// 上传文件
  //			try {
  //				stream = file.getInputStream();// 把文件读入
  //				bos = new FileOutputStream(realBaseDir + fileRealName);
  //				int a = 0;
  //				while((a = stream.read()) != -1){
  //					bos.write(a);
  //				}
  //				dataPath.append(fileRealName);
  //				Path = dataPath.toString();
  //			} catch (Exception e) {
  //				Path = "";
  //				//如果有异常，就删除这个文件
  //				File filev = new File(realBaseDir  + fileRealName);
  //				filev.delete();
  //				e.printStackTrace();
  //			}finally{
  //				//流关闭
  //				try {
  //					if(stream != null){
  //						stream.close();
  //					}
  //					if(bos != null){
  //						bos.close();
  //					}
  //
  //				} catch (IOException e) {
  //					e.printStackTrace();
  //				}
  //			}
  //		}
  //		return Path;
  //	}

}
