package com.devplatform.admin.modules.sys.dao;
import org.apache.ibatis.annotations.Mapper;

import com.devplatform.admin.modules.sys.model.SysSystemParamsModel;
import com.devplatform.admin.modules.sys.bean.SysSystemParams;
import com.devplatform.common.dao.MyBaseMapper;

import java.util.List;

/**
 * SysSystemParams Mapper
 * 用于系统全局参数表的数据库操作
 * @author Administrator
 *
 */
@Mapper
public interface SysSystemParamsDao extends MyBaseMapper<SysSystemParams> {

    /**
     * 查询分页数量
     * @param model
     * @return
     */
    Integer queryPageByCount(SysSystemParamsModel model);

    /**
     * 查询系统全局参数表分页数据
     * @param model
     * @return
     */
    List<SysSystemParams> queryPageList(SysSystemParamsModel model);
}
