package com.devplatform.admin.modules.sys.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.model.SysUserModel;
import com.devplatform.common.dao.MyBaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.HashMap;
import java.util.List;

/**
 * 系统用户
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:34:11
 */
@Mapper
public interface SysUserDao extends MyBaseMapper<SysUserEntity> {

  /**
   * 查询用户的所有权限
   * @param userId
   * @return
   */
  List<String> queryAllPerms(String userId);

  /**
   * 查询用户的所有菜单ID
   * @param userId
   * @return
   */
  List<String> queryAllMenuId(String userId);

  /**
   * 根据用户名，查询系统用户
   * @param username
   * @param stationId
   * @return
   */
  SysUserEntity queryByUserName(
      @Param("username") String username);

  /**
   * 查询用户列表
   * @param page
   * @param model
   * @return
   */
  public Page<SysUserEntity> queryByList(
      @Param("page") Page<SysUserEntity> page, @Param("model") SysUserModel model);

  /**
   * 根据id查询用户信息
   * @param userId
   * @return
   */
  public SysUserEntity getById(String userId);

  /**
   * 查询用户名重复数量
   * @param model
   * @return
   */
  public Integer queryUserById(SysUserEntity model);

  /**
   * 重置密码
   * @param username
   * @param password
   * @param sysSign
   */
  public void updatePassword(
      @Param("username") String username,
      @Param("password") String password,
      @Param("sysSign") String sysSign);

  /**
   * 根据机构名查询用户信息
   * @param orgId
   * @return
   */
  public List<HashMap<String, Object>> getUserInfoByOrgId(String orgId);

  /**
   * 根据机构名查询用户分页信息
   * @param page
   * @param map
   * @return
   */
  Page<HashMap<String, Object>> getAllUserByOrgIdPage(
      @Param("page") Page<HashMap<String, Object>> page, @Param("map") HashMap<String, Object> map);

  /**
   * 根据机构名查询用户信息
   * @param map
   * @return
   */
  List<HashMap<String, Object>> getAllUserByOrgId(HashMap<String, Object> map);

  /**
   * 修改密码
   * @param split
   * @param password
   * @param salt
   * @param userId
   * @param sysSign
   */
  void updatePw(
      @Param("split") String[] split,
      @Param("password") String password,
      @Param("salt") String salt,
      @Param("userId") String userId,
      @Param("sysSign") String sysSign);

  /**
   * 查询所有民族
   * @return
   */
  @Select("select * from sys_nation")
  List<HashMap<String, Object>> getAllNation();
}
