package com.devplatform.admin.modules.sys.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

/**
 * 菜单管理
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:26:39
 */
@ApiModel(value = "角色对象", description = "角色对象")
@TableName("sys_menu")
public class SysMenuModel {

  /** 菜单ID */
  @ApiModelProperty(value = "主键ID", name = "menuId")
  @TableId
  private String menuId;

  /** 父菜单ID，一级菜单为0 */
  @ApiModelProperty(value = "父菜单ID", name = "parentId")
  private String parentId;

  /** 父菜单名称 */
  @ApiModelProperty(value = "父菜单名称", name = "parentName")
  @TableField(exist = false)
  private String parentName;

  /** 菜单名称 */
  @ApiModelProperty(value = "菜单名称", name = "name")
  private String name;

  @ApiModelProperty(value = "菜单标题", name = "title")
  private String title;

  @ApiModelProperty(value = "菜单URL", name = "url")
  private String url;

  @ApiModelProperty(value = "菜单Path", name = "path")
  private String path;
  /** 授权(多个用逗号分隔，如：user:list,user:create) */
  @ApiModelProperty(value = "授权(多个用逗号分隔，如：user:list,user:create)", name = "perms")
  private String perms;

  /** 类型 0：目录 1：菜单 2：按钮 */
  @ApiModelProperty(value = "类型(0：目录   1：菜单   2：按钮)", name = "type")
  private Integer type;

  /** 菜单图标 */
  @ApiModelProperty(value = "菜单图标", name = "icon")
  private String icon;

  /** 排序 */
  @ApiModelProperty(value = "排序", name = "orderNum")
  private Integer orderNum;

  /** 是否系统菜单 */
  @ApiModelProperty(value = "是否系统菜单", name = "isSystemMenu")
  private String isSystemMenu;

  /** ztree属性 */
  @TableField(exist = false)
  private Boolean open;

  @TableField(exist = false)
  private List<SysMenuModel> list;

  @TableField(exist = false)
  private List<SysMenuModel> children;

  public String getMenuId() {
    return menuId;
  }

  public void setMenuId(String menuId) {
    this.menuId = menuId;
  }

  /**
   * 获取：父菜单ID，一级菜单为0
   *
   * @return String
   */
  public String getParentId() {
    return parentId;
  }

  /**
   * 设置：父菜单ID，一级菜单为0
   *
   * @param parentId 父菜单ID，一级菜单为0
   */
  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  /**
   * 获取：菜单名称
   *
   * @return String
   */
  public String getName() {
    return name;
  }

  /**
   * 设置：菜单名称
   *
   * @param name 菜单名称
   */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 获取：菜单URL
   *
   * @return String
   */
  public String getUrl() {
    return url;
  }

  /** 菜单URL */

  /**
   * 设置：菜单URL
   *
   * @param url 菜单URL
   */
  public void setUrl(String url) {
    this.url = url;
  }

  public String getPerms() {
    return perms;
  }

  public void setPerms(String perms) {
    this.perms = perms;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  /**
   * 获取：菜单图标
   *
   * @return String
   */
  public String getIcon() {
    return icon;
  }

  /**
   * 设置：菜单图标
   *
   * @param icon 菜单图标
   */
  public void setIcon(String icon) {
    this.icon = icon;
  }

  /**
   * 获取：排序
   *
   * @return Integer
   */
  public Integer getOrderNum() {
    return orderNum;
  }

  /**
   * 设置：排序
   *
   * @param orderNum 排序
   */
  public void setOrderNum(Integer orderNum) {
    this.orderNum = orderNum;
  }

  public List<SysMenuModel> getList() {
    return list;
  }

  public void setList(List<SysMenuModel> list) {
    this.list = list;
  }

  public String getParentName() {
    return parentName;
  }

  public void setParentName(String parentName) {
    this.parentName = parentName;
  }

  public Boolean getOpen() {
    return open;
  }

  public void setOpen(Boolean open) {
    this.open = open;
  }

  /**
   * 获取：是否系统菜单
   *
   * @return
   */
  public String getIsSystemMenu() {
    return isSystemMenu;
  }

  /**
   * 设置：是否系统菜单
   *
   * @param isSystemMenu
   */
  public void setIsSystemMenu(String isSystemMenu) {
    this.isSystemMenu = isSystemMenu;
  }

  public List<SysMenuModel> getChildren() {
    return children;
  }

  public void setChildren(List<SysMenuModel> children) {
    this.children = children;
  }

  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  /** 菜单标题 */
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }
}
