package com.devplatform.admin.modules.sys.oauth2;

import com.alibaba.fastjson.JSON;
import com.devplatform.common.util.R;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpStatus;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * oauth2过滤器
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2017-05-20 13:00
 */
public class Oauth2Filter extends AuthenticatingFilter {

  @Override
  protected AuthenticationToken createToken(ServletRequest request, ServletResponse response)
      throws Exception {
    // 获取请求token
    String token = getRequestToken((HttpServletRequest) request);

    if (StringUtils.isBlank(token)) {
      return null;
    }

    return new Oauth2Token(token);
  }

  @Override
  protected boolean isAccessAllowed(
      ServletRequest request, ServletResponse response, Object mappedValue) {
    if (((HttpServletRequest) request).getMethod().equals(RequestMethod.OPTIONS.name())) {
      return true;
    }

    return false;
  }

  @Override
  protected boolean onAccessDenied(ServletRequest request, ServletResponse response)
      throws Exception {
    // 获取请求token，如果token不存在，直接返回401
    String token = getRequestToken((HttpServletRequest) request);
    if (StringUtils.isBlank(token)) {
      HttpServletResponse httpResponse = (HttpServletResponse) response;
      httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
      httpResponse.setHeader("Access-Control-Allow-Origin", "*");

      String json = JSON.toJSONString(R.error(HttpStatus.SC_UNAUTHORIZED, "invalid token"));

      httpResponse.getWriter().print(json);

      return false;
    }

    return executeLogin(request, response);
  }

  @Override
  protected boolean onLoginFailure(
      AuthenticationToken token,
      AuthenticationException e,
      ServletRequest request,
      ServletResponse response) {
    HttpServletResponse httpResponse = (HttpServletResponse) response;
    httpResponse.setContentType("application/json;charset=utf-8");
    httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
    httpResponse.setHeader("Access-Control-Allow-Origin", "*");
    try {
      // 处理登录失败的异常
      Throwable throwable = e.getCause() == null ? e : e.getCause();
      R r = R.error(HttpStatus.SC_UNAUTHORIZED, throwable.getMessage());

      String json = JSON.toJSONString(r);
      httpResponse.getWriter().print(json);
    } catch (IOException e1) {

    }

    return false;
  }

  /** 获取请求的token */
  public String getRequestToken(HttpServletRequest httpRequest) {
    // 从header中获取token
    String token = httpRequest.getHeader("token");

    // 如果header中不存在token，则从参数中获取token
    if (StringUtils.isBlank(token)) {
      token = httpRequest.getParameter("token");
    }

    return token;
  }
}
