package com.devplatform.admin.modules.sys.service;

import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.bean.SysUserTokenEntity;
import java.util.Set;

/**
 * shiro相关接口
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2017-06-06 8:49
 */
public interface ShiroService {
  /**
   * 获取用户权限列表
   * @param userId
   * @return
   */
  Set<String> getUserPermissions(String userId);

  /**
   * 根据token查询用户信息
   * @param token
   * @return
   */
  SysUserTokenEntity queryByToken(String token);

  /**
   * 根据用户ID，查询用户
   * @param userId
   * @return
   */
  SysUserEntity queryUser(String userId);
}
