package com.devplatform.admin.modules.sys.service;

import com.devplatform.admin.modules.sys.bean.SysMenuEntity;
import com.devplatform.common.service.MyBaseService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 菜单管理
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:42:16
 */
public interface SysMenuService extends MyBaseService<SysMenuEntity> {

  /**
   * 根据父菜单，查询子菜单
   *
   * @param parentId 父菜单ID
   * @param menuIdList 用户菜单ID
   * @return
   */
  List<SysMenuEntity> queryListParentId(String parentId, List<String> menuIdList);

  /**
   * 根据父菜单，查询子菜单
   *
   * @param parentId 父菜单ID
   * @return
   */
  List<SysMenuEntity> queryListParentId(String parentId);

  /**
   * 获取不包含按钮的菜单列表
   * @return
   */
  List<SysMenuEntity> queryNotButtonList();

  /**
   * 获取用户菜单列表
   * @param userId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> getUserMenuList(String userId, String stationId);

  /**
   * 删除
   * @param menuId
   */
  void delete(String menuId);

  /**
   * 根据角色id查询菜单权限
   * @param roleId
   * @param stationId
   * @return
   */
  List<HashMap<String, Object>> getRoleMenu(String roleId, String stationId);

  /**
   * 查询用户的导航菜单
   * @param userId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> getNav(String userId, String stationId);
}
