package com.devplatform.admin.modules.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.model.SysUserModel;
import com.devplatform.common.service.MyBaseService;
import com.devplatform.common.util.R;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;

/**
 * 系统用户
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:43:39
 */
public interface SysUserService extends MyBaseService<SysUserEntity> {

  /**
   * 查询用户的所有权限
   * @param userId
   * @return
   */
  List<String> queryAllPerms(String userId);

  /**
   * 查询用户的所有菜单ID
   * @param userId
   * @return
   */
  List<String> queryAllMenuId(String userId);

  /**
   * 根据用户名，查询系统用户
   * @param username
   * @return
   */
  SysUserEntity queryByUserName(String username);

  /**
   * 保存用户
   * @param user
   * @return
   */
  @Override
  boolean save(SysUserEntity user);

  /**
   * 修改用户
   * @param user
   */
  void update(SysUserEntity user);

  /**
   * 删除用户
   * @param userIds
   * @param sysSign
   */
  void deleteBatch(String[] userIds, String sysSign);

  /**
   * 修改密码
   *
   * @param userId 用户ID
   * @param password 原密码
   * @param newPassword 新密码
   * @param sysSign 系统标识
   * @return
   */
  boolean updatePassword(String userId, String password, String newPassword, String sysSign);

  /**
   * 查询用户列表
   * @param page
   * @param model
   * @return
   */
  public Page<SysUserEntity> queryByList(Page<SysUserEntity> page, SysUserModel model);

  /**
   * 根据id查询用户
   * @param userId
   * @return
   */
  public SysUserEntity getById(String userId);

  /**
   * 查询用户名重复数量
   * @param model
   * @return
   */
  public Integer queryUserById(SysUserEntity model);

  /**
   * 重置密码
   * @param username
   * @param password
   * @param sysSign
   */
  public void updatePassword(
      @Param("username") String username,
      @Param("password") String password,
      @Param("sysSign") String sysSign);

  /**
   * 根据机构名称查询用户信息
   * @param orgId
   * @return
   */
  public List<HashMap<String, Object>> getUserInfoByOrgId(String orgId);

  /**
   * 根据机构名称查询用户信息
   * @param orgId
   * @param username
   * @param name
   * @param jobNumber
   * @param gender
   * @param status
   * @param sort
   * @param order
   * @param page
   * @param size
   * @param stationId
   * @return
   */
  R selectUserByOrgId(
      String orgId,
      String username,
      String name,
      String jobNumber,
      Integer gender,
      String status,
      String sort,
      String order,
      Integer page,
      Integer size,
      String stationId);

  /**
   * 修改密码
   * @param split
   * @param password
   * @param salt
   * @param userId
   * @param sysSign
   */
  void updatePw(String[] split, String password, String salt, String userId, String sysSign);

  /**
   * 查询所有民族
   * @return
   */
  List<HashMap<String, Object>> getAllNation();
}
