package com.devplatform.admin.modules.sys.service.impl;

import com.devplatform.admin.modules.sys.bean.SysMenuEntity;
import com.devplatform.admin.modules.sys.bean.SysUserEntity;
import com.devplatform.admin.modules.sys.bean.SysUserTokenEntity;
import com.devplatform.admin.modules.sys.dao.SysMenuDao;
import com.devplatform.admin.modules.sys.dao.SysUserDao;
import com.devplatform.admin.modules.sys.dao.SysUserTokenDao;
import com.devplatform.admin.modules.sys.service.ShiroService;
import com.devplatform.common.util.Constant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
/**
 * @author Administrator
 */
@Service
public class ShiroServiceImpl implements ShiroService {
  @Autowired(required = false)
  private SysMenuDao sysMenuDao;

  @Autowired(required = false)
  private SysUserDao sysUserDao;

  @Autowired(required = false)
  private SysUserTokenDao sysUserTokenDao;

  @Override
  public Set<String> getUserPermissions(String userId) {
    List<String> permsList;

    // 系统管理员，拥有最高权限
    if (userId.equals(Constant.SUPER_ADMIN)) {
      List<SysMenuEntity> menuList = sysMenuDao.selectList(null);
      permsList = new ArrayList<>(menuList.size());
      for (SysMenuEntity menu : menuList) {
        permsList.add(menu.getPerms());
      }
    } else {
      permsList = sysUserDao.queryAllPerms(userId);
    }
    // 用户权限列表
    Set<String> permsSet = new HashSet<>();
    for (String perms : permsList) {
      if (StringUtils.isBlank(perms)) {
        continue;
      }
      permsSet.addAll(Arrays.asList(perms.trim().split(",")));
    }
    return permsSet;
  }

  @Override
  public SysUserTokenEntity queryByToken(String token) {
    return sysUserTokenDao.queryByToken(token);
  }

  @Override
  public SysUserEntity queryUser(String userId) {
    return sysUserDao.getById(userId);
  }
}
