package com.devplatform.admin.modules.sys.service.impl;

import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.modules.sys.bean.SysMenuEntity;
import com.devplatform.admin.modules.sys.dao.SysMenuDao;
import com.devplatform.admin.modules.sys.model.SysMenuModel;
import com.devplatform.admin.modules.sys.service.SysMenuService;
import com.devplatform.admin.modules.sys.service.SysRoleMenuService;
import com.devplatform.admin.modules.sys.service.SysUserService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.BeanUtil;
import com.devplatform.common.util.Constant;
import com.devplatform.common.util.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
/**
 * @author Administrator
 */
@Service("sysMenuService")
public class SysMenuServiceImpl extends MyBaseServiceImpl<SysMenuDao, SysMenuEntity>
    implements SysMenuService {
  @Autowired private SysUserService sysUserService;
  @Autowired private SysRoleMenuService sysRoleMenuService;

  @Override
  public List<SysMenuEntity> queryListParentId(String parentId, List<String> menuIdList) {
    List<SysMenuEntity> menuList = queryListParentId(parentId);
    if (menuIdList == null || menuIdList.size() == 0) {
      return menuList;
    }

    List<SysMenuEntity> userMenuList = new ArrayList<>();
    for (SysMenuEntity menu : menuList) {
      if (menuIdList.contains(menu.getMenuId())) {
        userMenuList.add(menu);
      }
    }
    return userMenuList;
  }

  @Override
  public List<SysMenuEntity> queryListParentId(String parentId) {
    return baseMapper.queryListParentId(parentId);
  }

  @Override
  public List<SysMenuEntity> queryNotButtonList() {
    return baseMapper.queryNotButtonList();
  }

  @Override
  public List<Map<String, Object>> getUserMenuList(
      String userId, String stationId) {
    List<Map<String, Object>> list;
    // 系统管理员，拥有所有权限
    if (Constant.SUPER_ADMIN.equals(userId)) {
      list = baseMapper.getAllMenuListByUserId(null, stationId);
    } else {
        // 站点查询
        list = baseMapper.getAllMenuListByUserId(userId, stationId);
    }
    List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
    // 生成树结构
    Iterator<Map<String, Object>> iterator = list.iterator();
    while (iterator.hasNext()) {
      Map<String, Object> next = iterator.next();
//      if ((Integer) next.get("type") == 0) {
      if (Constants.STRING_0.equals(next.get(Constants.PID))) {
        result.add(next);
        iterator.remove();
      }
    }
    // 给一级标签添加子集
    List<Map<String, Object>> maps = addChildren(list, result);
    return maps;
  }

  @Override
  public void delete(String menuId) {
    // 删除菜单
    SysMenuEntity sysMenuEntity = new SysMenuEntity();
    sysMenuEntity.setMenuId(menuId);
    // 逻辑删除
    sysMenuEntity.setStatus(1);
    this.updateById(sysMenuEntity);
    // 删除菜单与角色关联
    sysRoleMenuService.removeByMap(new MapUtils().put("menu_id", menuId));
  }

  /** 获取所有菜单列表 */
  private List<SysMenuModel> getAllMenuList(List<String> menuIdList) {
    // 查询根菜单列表
    List<SysMenuEntity> menuList = queryListParentId("0", menuIdList);
    // 递归获取子菜单
    List<SysMenuModel> subMenuList = getMenuTreeList(menuList, menuIdList);

    return subMenuList;
  }

  /**
   * 添加子集
   * @param list
   * @param result
   * @return
   */
  public List<Map<String, Object>> addChildren(
      List<Map<String, Object>> list, List<Map<String, Object>> result) {
    for (Map<String, Object> firstMenu : result) {
      Iterator<Map<String, Object>> iterator = list.iterator();
      List<Map<String, Object>> array = new ArrayList<>();
      while (iterator.hasNext()) {
        Map<String, Object> menu = iterator.next();
        if (menu.get("parentId").equals(firstMenu.get("menuId"))) {
          array.add(menu);
          iterator.remove();
        }
      }
      firstMenu.put("list", array);
      if (array.size() > 0) {
        addChildren(list, array);
      }
    }
    return result;
  }

  /** 递归 */
  private List<SysMenuModel> getMenuTreeList(
      List<SysMenuEntity> menuList, List<String> menuIdList) {
    List<SysMenuModel> subMenuList = new ArrayList<>();

    for (SysMenuEntity entity : menuList) {
      SysMenuModel model = BeanUtil.convertBean(entity, SysMenuModel.class);
      model.setPath(entity.getUrl());
      model.setTitle(entity.getName());
      // 目录
      if (model.getType() == Constant.MenuType.CATALOG.getValue()) {
        model.setList(
            getMenuTreeList(queryListParentId(model.getMenuId(), menuIdList), menuIdList));
      }
      subMenuList.add(model);
    }

    return subMenuList;
  }

  @Override
  public List<HashMap<String, Object>> getRoleMenu(String roleId, String stationId) {
    return baseMapper.getRoleMenu(roleId, stationId);
  }

  @Override
  public List<Map<String, Object>> getNav(String userId, String stationId) {
    List<Map<String, Object>> nav = baseMapper.getNav(userId, stationId);
    ArrayList<Map<String, Object>> navlist = new ArrayList<>();

    Iterator<Map<String, Object>> iterator = nav.iterator();
    while (iterator.hasNext()) {
      Map<String, Object> next = iterator.next();
      if ((Integer) next.get("type") == 0) {
        next.put("name", next.get("path").toString().substring(1));
        next.put("component", "layoutHeaderAside");
        navlist.add(next);
        iterator.remove();
      }
    }
    for (Map<String, Object> map : navlist) {
      String menuId = (String) map.get("menuId");
      ArrayList<Map<String, Object>> children = new ArrayList<>();
      Iterator<Map<String, Object>> it = nav.iterator();
      while (it.hasNext()) {
        Map<String, Object> next = it.next();
        if (menuId.equals(next.get("parentId"))) {
          next.remove("menuId");
          next.remove("parentId");
          next.remove("type");
          String path = (String) next.get("path");
          if (StringUtils.isBlank(path)) {
            continue;
          }
          next.put("path", path.substring(path.lastIndexOf("/") + 1));
          next.put("name", path.substring(1).replace("/", "-"));
          next.put("component", path);
          children.add(next);
          it.remove();
        }
      }
      if (children.isEmpty()) {
        HashMap<String, Object> map1 = new HashMap<>(5);
        String path = (String) map.get("path");
        map1.put("path", path);
        map1.put("name", map.get("name"));
        StringBuilder sb = new StringBuilder();
        sb.append("() => import('@/pages").append(path).append("')");
        map1.put("component", sb.toString());
        children.add(map1);
      }
      map.put("children", children);
      map.remove("menuId");
      map.remove("parentId");
      map.remove("type");
    }
    return navlist;
  }
}
