package com.devplatform.admin.modules.sys.service.impl;

import com.devplatform.admin.common.utils.DateUtil;
import com.devplatform.admin.modules.sys.bean.SysOss;
import com.devplatform.admin.modules.sys.dao.SysOssDao;
import com.devplatform.admin.modules.sys.service.SysOssService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/**
 * 附件信息表的service接口实现类 <br>
 * <b>功能：</b>SysOssServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("sysOssService")
public class SysOssServiceImpl extends MyBaseServiceImpl<SysOssDao, SysOss>
    implements SysOssService {
  @Value("${upload.realBaseDir}")
  private String realBaseDir;

  @Override
  public String upload(MultipartFile file, String type, String stationId) {
    String path = "";
    String fileNameString = "";
    if (file != null && !file.isEmpty()) {
      String pathStr =
          "upload/" + stationId + "/map/" + DateUtil.dateToString(new Date(), "yyyymm") + "/";
      fileNameString = realBaseDir + pathStr;
      String uuid = UUID.randomUUID() + ".jpg";
      fileNameString = fileNameString + uuid;

      // 建立文件夹
      System.out.println(realBaseDir + pathStr);
      File baseFile = new File(realBaseDir + pathStr);

      if (!baseFile.exists()) {
        baseFile.mkdirs();
      }

      path = pathStr + uuid;
      // 上传
      try {
        file.transferTo(new File(fileNameString));
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return path;
  }
}
