package com.devplatform.admin.modules.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.admin.modules.sys.bean.SysRoleMenuEntity;
import com.devplatform.admin.modules.sys.dao.SysRoleMenuDao;
import com.devplatform.admin.modules.sys.service.SysRoleMenuService;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 角色与菜单对应关系
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:44:35
 */
@Service("sysRoleMenuService")
public class SysRoleMenuServiceImpl extends MyBaseServiceImpl<SysRoleMenuDao, SysRoleMenuEntity>
    implements SysRoleMenuService {

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void saveOrUpdate(String sysSign, String roleId, List<String> menuIdList) {
    // 先删除角色与菜单关系
    deleteBatch(new String[] {roleId});

    if (menuIdList.size() == 0) {
      return;
    }

    // 保存角色与菜单关系
    List<SysRoleMenuEntity> list = new ArrayList<>(menuIdList.size());
    for (String menuId : menuIdList) {
      SysRoleMenuEntity sysRoleMenuEntity = new SysRoleMenuEntity();
      sysRoleMenuEntity.setMenuId(menuId);
      sysRoleMenuEntity.setRoleId(roleId);
      sysRoleMenuEntity.setSysSign(sysSign);

      list.add(sysRoleMenuEntity);
    }
    this.saveBatch(list);
  }

  @Override
  public List<String> queryMenuIdList(String roleId, String stationId) {
    return baseMapper.queryMenuIdList(roleId, stationId);
  }

  @Override
  public int deleteBatch(String[] roleIds) {
    return baseMapper.deleteBatch(roleIds);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void updateRoleMenu(
      String sysSign, String roleId, ArrayList<String> menuIds, String stationId) {

    // 清空所有权限
    baseMapper.delete(new QueryWrapper<SysRoleMenuEntity>().eq("role_id", roleId));

    if (menuIds == null || menuIds.size() == 0) {
      return;
    }

    ArrayList<SysRoleMenuEntity> list = new ArrayList<>();
    for (String menuId : menuIds) {
      SysRoleMenuEntity sysRoleMenuEntity = new SysRoleMenuEntity();
      sysRoleMenuEntity.setMenuId(menuId);
      sysRoleMenuEntity.setRoleId(roleId);
      sysRoleMenuEntity.setSysSign(sysSign);
      sysRoleMenuEntity.setStationId(stationId);
      list.add(sysRoleMenuEntity);
    }
    // 添加权限
    this.saveBatch(list);
  }
}
