package com.devplatform.admin.modules.sys.service.impl;

import com.devplatform.admin.modules.sys.bean.SysRoleEntity;
import com.devplatform.admin.modules.sys.bean.SysUserRoleEntity;
import com.devplatform.admin.modules.sys.dao.SysRoleDao;
import com.devplatform.admin.modules.sys.service.SysRoleMenuService;
import com.devplatform.admin.modules.sys.service.SysRoleService;
import com.devplatform.admin.modules.sys.service.SysUserRoleService;
import com.devplatform.admin.modules.sys.service.SysUserService;
import com.devplatform.common.base.exception.RRException;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 角色
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2016年9月18日 上午9:45:12
 */
@Service("sysRoleService")
public class SysRoleServiceImpl extends MyBaseServiceImpl<SysRoleDao, SysRoleEntity>
    implements SysRoleService {
  @Autowired private SysRoleMenuService sysRoleMenuService;
  @Autowired private SysUserService sysUserService;
  @Autowired private SysUserRoleService sysUserRoleService;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public boolean saveMenu(SysRoleEntity role) {
    role.setCreateTime(new Date());
    this.save(role);

    sysRoleMenuService.saveOrUpdate(role.getSysSign(), role.getRoleId(), role.getMenuIdList());
    return true;
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void update(SysRoleEntity role) {
    this.updateById(role);

    // 检查权限是否越权
    //        checkPrems(role);

    // 更新角色与菜单关系
    sysRoleMenuService.saveOrUpdate(role.getSysSign(), role.getRoleId(), role.getMenuIdList());
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void deleteBatch(String[] roleIds, String sysSign) {
    ArrayList<SysRoleEntity> list = new ArrayList<>();
    for (String ro : roleIds) {
      SysRoleEntity sysRoleEntity = new SysRoleEntity();
      sysRoleEntity.setRoleId(ro);
      // 逻辑删除
      sysRoleEntity.setDeleted(1);
      sysRoleEntity.setSysSign(sysSign);
      sysRoleEntity.setUpdateTime(new Date());
      list.add(sysRoleEntity);
    }
    if (list.size() > 0) {
      this.updateBatchById(list);
    }

    // 删除角色与菜单关联
    sysRoleMenuService.deleteBatch(roleIds);

    // 删除角色与用户关联
    sysUserRoleService.deleteBatch(roleIds);
  }

  @Override
  public List<String> queryRoleIdList(String createUserId) {
    return baseMapper.queryRoleIdList(createUserId);
  }

  /** 检查权限是否越权 */
  private void checkPrems(SysRoleEntity role) {
    // 如果不是超级管理员，则需要判断角色的权限是否超过自己的权限
    if (role.getCreateUserId().equals(Constant.SUPER_ADMIN)) {
      return;
    }

    // 查询用户所拥有的菜单列表
    List<String> menuIdList = sysUserService.queryAllMenuId(role.getCreateUserId());

    // 判断是否越权
    if (!menuIdList.containsAll(role.getMenuIdList())) {
      throw new RRException("新增角色的权限，已超出你的权限范围");
    }
  }

  /**
   * 查询用户选择的角色列表
   *
   * @param userId
   * @return
   */
  @Override
  public List<SysRoleEntity> queryUserRoleList(String userId) {
    return baseMapper.queryUserRoleList(userId);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void addRole(String sysSign, String userId, String roleIds, String stationId) {

    // 删除当前用户所有角色信息
    baseMapper.deleteUserRole(userId);

    if (StringUtils.isNotBlank(roleIds)) {
      ArrayList<SysUserRoleEntity> role = new ArrayList<>();
      String[] split = roleIds.split(",");

      for (String s : split) {
        SysUserRoleEntity sysUserRoleEntity = new SysUserRoleEntity();
        sysUserRoleEntity.setRoleId(s);
        sysUserRoleEntity.setUserId(userId);
        sysUserRoleEntity.setSysSign(sysSign);
        sysUserRoleEntity.setStationId(stationId);
        role.add(sysUserRoleEntity);
      }
      sysUserRoleService.saveBatch(role);
    }
  }

  @Override
  public void updateRole(SysRoleEntity role) {
    this.updateById(role);
  }
}
